/* The track editor */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "int.h"

#include "main.h"
#include "tracks.h"
#include "selectlist.h"
#include "tracklist.h"
#include "streams.h"
#include "fileman.h"
#include "trackedit.h"
#include "preferences.h"
#include "precachetrack.h"
#include "stdfiletrack.h"
#include "dirlow.h"
#include "helpings.h"
#include "updatehandlers.h"
#include "fsedit.h"
#include "internal.h"
#include "tracklist.h"
#include "menusys.h"
#include "trackdoubleclick.h"
#include "vfs.h"
#include "dialog.h"
#include "forms.h"

/* uncomment for debugging */
/* #define DEBUG */

void trackedit_removehandler(GtkWidget *w,selectlist_info *info);
void trackedit_renametrack(GtkWidget *w,selectlist_info *info);
static menusys_menu trackedit_popupmenu[]=
{
   MENUSYS_ITEM_NONE(N_("Delete Track"),N_("Remove selected track(s) from the tracklist"),trackedit_removehandler),
   MENUSYS_ITEM_NONE(N_("Encode as.."),N_("Encode this object to a certain filetype"),selectlist_encodetofile),
   MENUSYS_ITEM_NONE(N_("Rename Track.."),N_("Change Title, Artist and Name of a track"),trackedit_renametrack),
   MENUSYS_ITEM_END
};

tracklist_info *trackedit;

void trackedit_renametrack(GtkWidget *w,selectlist_info *info)
{
   GList *c;
   for (c=trackedit->selectlistinfo->selected_lines;
	c!=NULL;
	c=c->next)
     {
	tracks_trackinfo *track=
	  tracklist_gettrack(trackedit,(int)c->data);
	/* FIXME: claim track and unclaim it when dialog gets closed */
	if (track)
	  forms_create(_("Rename track"),
		       5,
		       &track->updatehandlers,
		       FORMS_ENTRY,
		       _("Track Name"),
		       track->name,
		       FORMS_NEWLINE,
		       FORMS_ENTRY,
		       _("Title"),
		       track->title,
		       FORMS_NEWLINE,
		       FORMS_ENTRY,
		       _("Artist"),
		       track->performer);
     };
};

void trackedit_removehandler(GtkWidget *w,selectlist_info *info)
{
   char *files;
   GList *c;

   files=selectlist_getselection(info);
#ifdef DEBUG
   printf ("trackedit_removehandler: removing tracks %s\n",files);
#endif

   /* delete all selected tracks */
   for (c=trackedit->selectlistinfo->selected_lines;
	c!=NULL;
	c=trackedit->selectlistinfo->selected_lines)
     tracklist_removetrack(trackedit,
			   (int)c->data);
};

void trackedit_streamdrop(char *s,
			  gpointer generic_userdata,
			  gpointer user_data,
			  fileman_additems_continuecb cont,
			  fileman_additems_state *contdata)
{

   int dragtype=(int)generic_userdata;
   int pos=(int)user_data;

   tracks_trackinfo *newtrack;

   newtrack=streams_getstreambyid((char*)(strchr(s,":"[0])+1));

   if (newtrack!=NULL)
     {
	if (dragtype==DNDSETUP_COPY)
	  newtrack->precacherequired=atadd;
	/* add the track to the list */
	tracklist_inserttrack(trackedit,pos,newtrack);
#ifdef DEBUG
	printf ("trackedit_streamdrop: added stream to tracklist at position %i\n",
		pos);
#endif DEBUG
     }
   else
     {
	printf ("processing remote streams is currently not supported.\n");
	printf ("This message occurred because you tried to drop a stream handled by\n");
	printf ("another instance of Gnome Toaster to the tracklist.\n");
	printf ("Contact A.Eckleder@bigfoot.com if you think this was not the case.\n");
     }
   ;
   /* this will make for a nice recursion.
    * the *_iterate function of fileman is recursion-safe, though.
    * It will not do anything bad and take care of itself
    * (hopefully ;-)) */
   cont(contdata);
}
;

void trackedit_realfile2track(char *s,int pos,int dragtype)
{
   tracks_trackinfo *newtrack;
   newtrack=stdfiletrack_create(s);
   if (newtrack!=NULL)
     {
	if (dragtype==DNDSETUP_COPY)
	  newtrack->precacherequired=atadd;
	tracklist_inserttrack(trackedit,pos,newtrack);
	/* unclaim() the track,keeping only the reference
	 * stored in the tracklist */
	tracks_unclaim(newtrack);
     };
};

void trackedit_filedrop(char *s,
			gpointer generic_userdata,
			gpointer user_data,
			fileman_additems_continuecb cont,
			fileman_additems_state *contdata)
{

   int dragtype=(int)generic_userdata;
   int pos=(int)user_data;

   char *path=strdup(s);
   vfs_filesystem *fs=vfs_parseuri(s,path);
   if (fs)
     {
	if (!vfs_isdirectory(fs,path))
     /* test if file is a directory */
	  {
	/* test if file is an .m3u playlist file */
	     if (!strcasecmp(&path[strlen(path)-4],".m3u"))
	       {
		  FILE *fd;
		  char buffer[MAXPATHLENGTH+1];
		  int vfd=vfs_openfile(fs,path);
#ifdef DEBUG
		  printf ("trackedit_filedrop: got .m3u playlist\n");
#endif

		  fd=fdopen(vfd,"r");
		  if (fd!=NULL)
		    {
		       char *pathofm3u=helpings_pathonly(path);		       
		       while (!feof(fd))
			 {
			    *buffer=0;
			    fgets(buffer,MAXPATHLENGTH,fd);
		       /* ignore CR + LF */
			    if (strchr(buffer,13)!=NULL)
			      *strchr(buffer,13)=0;
			    if (strchr(buffer,10)!=NULL)
			      *strchr(buffer,10)=0;
#ifdef DEBUG
			    printf ("trackedit_filedrop: adding playlist file \"%s\"\n",
				    buffer);
#endif
			    if (strlen(buffer)>0)
			      {
				 /* If the path in an .m3u is relative,
				  * make it relative to the path of the .m3u */
				 char *fullpath=((buffer[0]!='/')
						 ?helpings_fileinpath(pathofm3u,buffer)
						 :strdup(buffer));
				 char *curi=(char*)malloc(strlen(fullpath)+strlen("file:")+1);
				 strcpy(curi,"file:");
				 strcat(curi,fullpath);
				 trackedit_realfile2track(curi,pos,dragtype);
				 free(curi);
				 free(fullpath);
			      };
			 };
		       free(pathofm3u);
		       fclose (fd);
		    };
	       }
	     else
	       {
		  trackedit_realfile2track(s,pos,dragtype);
	       };
	  }
	else
	  printf ("trackedit.c: no handler defined for directories\n");
     }; // invalid filesystem
   free(path);

   /* this will make for a nice recursion.
    * the *_iterate function of fileman is recursion-safe, though.
    * It will not do anything bad and take care of itself
    * (hopefully ;-)) */
   cont(contdata);
}
;

/* maybe we should extract all those precaching functions from trackedit.c
 * and into a separate file. */
int prereading;         /* TRUE if prereading process running */
int preread_current;
/* holds the desired precaching mode (atadd,atwrite) */
tracks_precache preread_mode;
/* this var holds a pointer to the callback function to be called
 * when precaching is done */
trackedit_finished_precache_cb preread_donecallback;

int trackedit_cachenexttrack(gpointer data);

void trackedit_prereadcb(tracks_trackinfo *finished,int success)
{
   /* checking the return state of the precaching function is more
    * important than ever now - if precaching wasnt successful,
    * the track returned in finished is simply invalid */
   if (success)
     {
	/* update data in tracklist */
	tracklist_replacetrack(trackedit,preread_current,finished);
     }
   ;
   /* process remaining tracks */
   gtk_timeout_add(500,trackedit_cachenexttrack,NULL);
}
;

int trackedit_cachenexttrack(gpointer data)
{
   int nextfound;

   preread_current++;
   nextfound=0;
   while ((preread_current<trackedit->entries)&&(!nextfound))
     {
	/* precache everything that matches the mode of the current precaching
	 * cycle or should already have been processed in a previous one */
	if (tracklist_gettrack(trackedit,preread_current)->precacherequired>=preread_mode)
	  {
	     /* replacing the track by its precache track is no
	      * longer handled in trackedit.c,hence we do not
	      * need to do anything to the tracklist at the moment
	      * its cleaner so anyway */
	     precachetrack_create(tracklist_gettrack(trackedit,preread_current),
				  trackedit_prereadcb);
	     nextfound=1;
	  }
	else
	  preread_current++;
     }
   ;
   prereading=nextfound; /* clear prereading flag if no further tracks */
   /* do a callback once done */
   if ((!nextfound)&&(preread_donecallback!=NULL))
     preread_donecallback();

   return 0;
}
;

/* precache tracks specified by mode and call callback once done */
void trackedit_doprereading(tracks_precache mode,
			    trackedit_finished_precache_cb callback)
{
   if (!prereading)
     {
	preread_current=-1;
	preread_mode=mode;
	preread_donecallback=callback;
	gtk_timeout_add(0,trackedit_cachenexttrack,NULL);
     }
   else
     if (preread_donecallback!=NULL)
       preread_donecallback();
}
;

void trackedit_dnddone(int status,gpointer data)
{
   trackedit_doprereading(atadd,NULL);
   /* call the prereading process which steps
    * through the whole tracklist and
    * prereads tracks that have to be preread */
};

int trackedit_drophandler(const char *s,int x,int y,int dragtype,gpointer data)
{
   int listpos;
   /* apparently we need a dummy because clist_get_selection_info
    * does not accept NULL pointers for arguments we dont need */
   int dummy;
   /* check the result of the get_selection_info call. If result is false
    * the position of the drop was not within the current tracklist.
    * The dropped track is simply appended to the list in that case */
   int result;

   /* get drop position within the tracklist */
   result=gtk_clist_get_selection_info(trackedit->selectlistinfo->self,
				       x,y,
				       &listpos,
				       &dummy);
   --listpos;
   /* -1: append track(s) to the list */
   if ((!result)||(listpos>trackedit->entries))
     listpos=-1;

#ifdef DEBUG
   printf ("trackedit_drophandler: got selectlist position for (%i,%i): %i\n",
	   x,y,listpos);
#endif

   /* check if this was an internal drop first */
   if (!tracklist_handleinternaldrop(trackedit,listpos))
     {
	fileman_additemlist(g_list_reverse(helpings_convertdndlist(s)),
			    trackedit_dnddone,
			    NULL,

			    (gpointer)dragtype,

			    2,

			    /* Handlers are stored in reverse order !!! */

			    /* everything else */
			    "",
			    trackedit_filedrop,
			    (gpointer)listpos,

			    "stream:",
			    trackedit_streamdrop,
			    (gpointer)listpos

			    );
     };
   return 1;
}
;

void trackedit_addisofs_addquestion(int reply,gpointer data)
{
   if (!reply)
     tracklist_inserttrack(trackedit,0,iso);
};

/* if the iso filesystem is edited with fsedit and nothing has been done
 * and the tracklist of trackedit is empty,add the isotrack to the
 * tracklist */
void trackedit_addisofs(gpointer data)
{
   /* add iso track here but do not initiate prereading as this could
    * well be annoying in that situation */
   if (trackedit->entries==0)
     trackedit_addisofs_addquestion(0,NULL);
   else
     {
	if (!tracklist_hastrack(trackedit,iso))
	  dialog_question(_("You have used the Filesystem Editor but\n"
			    "the ISO track is currently not in the list of tracks\n"
			    "to be burned. Do you want me to add it for you ?\n"),
			  trackedit_addisofs_addquestion,
			  NULL);
     };
}
;

const char *tracktitlemessage = N_("Unnamed disc (Click title to set disc info)");

GList *trackedit_titleauthor_updatehandler= NULL;

typedef struct
{
   char newtitle[256];
   char newauthor[256];
   tracklist_info *tracklist;
} settitleauthor_cbinfo_t;

void trackedit_settitleauthor_donecb(gpointer data)
{
   settitleauthor_cbinfo_t *info = (settitleauthor_cbinfo_t*)data;
   if (info)
     {
	updatehandlers_unregister(&trackedit_titleauthor_updatehandler,
				  trackedit_settitleauthor_donecb,
				  info);
	tracklist_setauthortitleinfo(info->tracklist,strlen(info->newauthor)?info->newauthor:NULL,strlen(info->newtitle)?info->newtitle:NULL);
	free(info);
     };
};

void trackedit_settitleauthor(tracklist_info *info)
{
   settitleauthor_cbinfo_t *cbinfo=(settitleauthor_cbinfo_t*)malloc(sizeof(settitleauthor_cbinfo_t));   
   if (info->author)
     strcpy(cbinfo->newauthor, info->author);
   else
     cbinfo->newauthor[0]=0;
   if (info->title)
     strcpy(cbinfo->newtitle, info->title);
   else
     cbinfo->newtitle[0]=0;
   cbinfo->tracklist=info;
   
   updatehandlers_register(&trackedit_titleauthor_updatehandler,
			   trackedit_settitleauthor_donecb,
			   cbinfo);

   forms_create(_("Set disc informations"),3,&trackedit_titleauthor_updatehandler,
		FORMS_ENTRY,_("Disc Title"),cbinfo->newtitle,FORMS_NEWLINE,
		FORMS_ENTRY,_("Artist/Author"),cbinfo->newauthor);
};

void trackedit_settitleauthor_cb(GtkWidget *w,int column, gpointer data)
{
   if ((column==0)&&data)
     trackedit_settitleauthor((tracklist_info*)data);
}; 

/* we essentially create the tracklist structure here,all internal
 * handling functions of the tracklist have been moved to tracklist.c */
GtkWidget *trackedit_create()
{
   trackedit=tracklist_info_create(trackedit_drophandler,
				   1,
				   trackedit_popupmenu,
				   GTK_SIGNAL_FUNC(trackdoubleclick_handler),
				   _(tracktitlemessage));

   updatehandlers_register(&fsedit_updatehandlers,
			   trackedit_addisofs,
			   NULL);

   // This is for editing the CD-Text title/author of the disc
   gtk_clist_column_title_active(trackedit->selectlistinfo->self,0);
   gtk_signal_connect(GTK_OBJECT(trackedit->selectlistinfo->self),"click_column",
		      GTK_SIGNAL_FUNC(trackedit_settitleauthor_cb),trackedit);

   return trackedit->widget;
}
;

void trackedit_destroy()
{
   tracklist_info_destroy(trackedit);
};
