/* This file implements the various input widgets for the preferences 
 * of Gnome Toaster. The most important thing about those widgets is that
 * all of them take a varman variable as argument,which is then directly
 * affected by any changes done to the input widget. */

#ifndef VARMANWIDGETS_H
#define VARMANWIDGETS_H

#include <gtk/gtk.h>

#include "varman.h"

typedef struct 
{
	GtkWidget *visual; /* the whole object */
	GtkWidget *label;  /* the label */
	GtkWidget *edit;   /* whats being edited by the user */
	varman_database *database;
	char varname[256];
	char activetext[256];   /* used by widgets describing two states */
	char inactivetext[256]; /* used by widgets describing two states */
} varmanwidgets_widget;

#define APPLYMODE_ALWAYS 0
#define APPLYMODE_BUTTON 1
#define APPLYMODE_OTHER  2
/* var:         name of the var to edit,
 * database:    database the var resides in
 * apply_mode:  should the var get updated 
 *              always/when apply button is pressed
 *              /when any other event occurs ?  */
varmanwidgets_widget *varmanwidgets_entry_new(char *label,
					      char *var,
					      varman_database *database,
					      int apply_mode,
					      int labelsize,
					      int editsize);
varmanwidgets_widget *varmanwidgets_checkbox_new(char *label,
						 char *var,
						 varman_database *database,
						 int apply_mode,
						 int labelsize,
						 char *activetext,
						 char *inactivetext);
varmanwidgets_widget *varmanwidgets_combo_new(char *label,
					      char *var,
					      varman_database *database,
					      int apply_mode,
					      int labelsize,
					      GList *popdown);
#define varmanwidgets_combo_setpops(widget,popstrings) \
        gtk_combo_set_popdown_strings(GTK_COMBO(widget->edit),popstrings)
/* restore the value of the var the combobox relates to back into the
 * combobox itself,w can be set to NULL,it is ignored entirely */ 
void varmanwidgets_combo_undo(GtkWidget *w,varmanwidgets_widget *d);

varmanwidgets_widget *varmanwidgets_spin_new(char *label,
					     char *var,
					     varman_database *database,
					     int apply_mode,
					     int labelsize,
					     GtkAdjustment *adj);


#endif // VARMANWIDGETS_H	
	
	
	
	
	
