// 
// simple spinlocks
// Author: Mick Dwyer, 2000
//
// $Id: spinlock.cc,v 1.2 2000/12/15 23:30:26 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/spinlock.cc,v $
// $Revision: 1.2 $
// $Date: 2000/12/15 23:30:26 $
// $State: Exp $
// 
// Note: probably should be done differently under Linux.
//  (see article written by Linus Torvalds on kernel mailing list).
//
#include "spinlock.h"

// initialize the lock to unlocked.
void s_lock_init(int *lkd)
{
    asm("movl   %0, %%eax; movl    $0, (%%eax)" : "=g" (lkd));
}

// keep trying until you get the lock.
void s_lock(int *lkd)
{
    asm("movl	%0, %%eax;\
		movl	$1, %%ecx;\
		setlock:\
		xchgl	%%ecx, (%%eax);\
		testl	%%ecx, %%ecx;\
		jz	gotit;\
		wait:\
		cmpl	$0, (%%eax);\
		jne wait;\
		jmp	setlock;\
		gotit:\
	": "=g" (lkd));
	
}

// unlock the lock.
void s_unlock(int *lkd)
{
    asm("movl   %0, %%eax; movl    $0, (%%eax)" : "=g" (lkd));
}
