// This may look like C code, but it is really -*- C++ -*-

#ifndef _node_support_Processed
#define _node_support_Processed 1

// node_support.h
// ------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Defines the node structure 


#ifdef REFGC
#include "Ref.h"
#define NULLO RefNil
#else
#define NULLO NULL
#endif

#include "machine.h"
#include "sched.h"

typedef enum boolean { false, true };
typedef enum status { ack, nak };
typedef int nodenum;
typedef int linknum;

#define NODELINK(node, link )	(((node)<<16) + (link))
#define NODE( nodelink )		((nodelink) >> 16)
#define LINK( nodelink )		((nodelink) & 0xFFFF )

struct message {
	PMAction arrival;	// post this on arrival if nonNULL
				// with arg = the dest'n.
	timetype starttime;	// clock when launched
	timetype activetime;	// clock when began activity (end of wait)
	timetype lastbittime;	// clock when last bit hits dest
	int hopcount;		// 1 when mesg sent, ++ when forwarded
				// (at dest, is the # of links used )
				// (i.e. becomes the message's distance )
	int probecount;		// 1 when mesg sent, ++ when forwarded,
				// ++ when reforwarded (i.e. if no traffic
				// encountered is same as hopcount )
	int retrycount;		// (init = 0) # of times retried delivering.
				// (when exceeds retry_count, stop trying)
	boolean reuse;		// if true, sender mustn't delete(measure.note)
				// because the arrival action is re-using it.
	int distance;		// from source to dest
	nodenum source;
	nodenum truesource;	// != source if a "reply" message occurred
	nodenum dest;
	int length;		// bits in packet
};

/*
#ifdef REFGC
typedef Ref<struct message> MessagePtr;
#else
typedef struct message* MessagePtr;
#endif
*/

struct header {			// as specified by k(k-1) algorithm
	nodenum dest;
	int distance;
	int historytag;
};
#define RAM -1
struct link {
	boolean busy;			// busy during setup, transfer
	boolean broken;			// if true, edited out of existance.
					// busy should = true & stay that way
	linknum lin;			// link# being xbarred to this link
					// ( -1 means RAM )
	linknum lout;			// link# this link is xbarred to
	MessagePtr pm;		        // being sent on this link
	struct header head;		// sent over this link
};

typedef enum nodestatus { nodefree, nodebusy };
struct node {
	nodestatus status;	// Node is busy when its historytag is in use,
				// ie during setup (until ack). It is free
				// during dataflow and teardown.
	int ram_port_count;	// # of the ports to RAM in use.
	boolean broken;	// if true, node edited out of existence.
			// busy should = true and stay that way.
	LinkedListPtr eventq;	// that are waiting for not-busy
	int eventqcount;
	int eventqmax;
	struct link links[ MAX_CUBE_ORDER ];
	int historytag;
};


//extern node nodes[ MAX_CUBE_SIZE ];
extern node* nodes;

#endif /* _node_support_Processed */
