/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef	XAUX_ATOMMNG_H
#define	XAUX_ATOMMNG_H

#pragma ident	"$Id$"

#define	XAUX_ATOMMNG_SX_SUFFIX	"_sx"
#define	XAUX_ATOMMNG_XS_SUFFIX	"_xs"

typedef struct xaux_atommng_data_struct {
	Atom		atom_sx;	/* atom sx */
	Bool		atom_sx_inuse;	/* atom sx is in use */
	Atom		atom_xs;	/* atom xs */
	Bool		atom_xs_inuse;	/* atom xs is in use */
	const char	*classname;	/* class name */
	int		idx;		/* index of last time */
	Bool		is_xs;		/* True: xs, False: sx */
	Display		*display;	/* display */
	Window		win;		/* window */
} xaux_atommng_data_t;

#define	XAUX_ATOMMNG_HASHSIZE		XAUX_MAXNPROPS_INIT

extern xaux_atommng_data_t *xaux_atommng_alloc_data(const char*, Bool, Display*);
extern Atom xaux_atommng_get_atom(xaux_atommng_data_t*, Window);
extern Bool xaux_atommng_check_atom(xaux_atommng_data_t*, Bool, Atom);
extern Bool xaux_atommng_release_atom(xaux_atommng_data_t*);
extern void xaux_atommng_free_data(xaux_atommng_data_t*);
extern Bool xaux_atommng_process_delete(xaux_atommng_data_t*, XPropertyEvent *);
extern Bool xaux_atommng_process_selclr(xaux_atommng_data_t*, XSelectionClearEvent *);
extern Atom xaux_atommng_know_atom(xaux_atommng_data_t*, Bool);

typedef struct xaux_propq_prop_struct {
	struct xaux_propq_prop_struct	*prev;
	struct xaux_propq_prop_struct	*next;
	unsigned char			*buf;
	int				len;
} xaux_propq_prop_t;

typedef struct xaux_propq_struct {
	int			count;
	size_t			totalsz;
	size_t			maxtotalsz;
	xaux_propq_prop_t	*list;
} xaux_propq_t;

extern xaux_propq_t *xaux_propq_alloc(size_t);
extern int xaux_propq_add(xaux_propq_t *, unsigned char *, int);
extern int xaux_propq_check(xaux_propq_t *);
extern int xaux_propq_get(xaux_propq_t *, unsigned char **, int *);
extern void xaux_propq_clean(xaux_propq_t *);
extern void xaux_propq_free(xaux_propq_t *);

#endif	/* !XAUX_ATOMMNG_H */
