/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef	XAUX_SO_COMMON_H
#define	XAUX_SO_COMMON_H

#pragma ident	"$Id$"

#define	XAUX_SO_NATOMS_READLIST		XAUX_MAXNPROPS_INIT

typedef struct _aux_icid {
	aux_t *			aux;
	int			icid;
	int			imid;
	Display			*dpy;	/* display */
	Bool			server;	/* True if attached to htt_xbe */
	struct _aux_icid *	prev;
	struct _aux_icid *	next;
} aux_icid_t;

typedef enum xaux_so_extstate_enum {
	Initial,
	Launched,
	Connected,
	ErrorTemp,
	ErrorPerm,
	Disconnected
} xaux_so_extstate_t;

typedef struct _xaux_so_setv_state {
	Bool		stored;
	int		seqno;
	aux_data_t	aux_data_;
	aux_data_t	*aux_data;
	int		segno;
	int		int_next;
	int		str_next;
	int		str_yet;
	int		outbufsz;
	char		*outbuf;
	int		maxnprops;
	int		nprops;
	unsigned char	**props;
} xaux_so_setv_state_t;

#include	<sys/types.h>

#define	XAUX_SO_EXECMNG_LOGSIZE			8
#define	XAUX_SO_EXECMNG_FAILSINPERIOD_TRIES	5
#define	XAUX_SO_EXECMNG_FAILSINPERIOD_PERIOD	5

typedef struct xaux_so_execmng_log_struct {
	time_t			time;
	xaux_so_extstate_t	state;
} xaux_so_execmng_log_t;

typedef struct xaux_so_execmng_data_struct {
	xaux_so_execmng_log_t	log[XAUX_SO_EXECMNG_LOGSIZE];
} xaux_so_execmng_data_t;

#define	XAUX_SO_NOTIFY_STATE_ID			0x60
#define	XAUX_SO_NOTIFY_STATE_OK			1
#define	XAUX_SO_NOTIFY_STATE_STANDBY		2
#define	XAUX_SO_NOTIFY_STATE_NOTAVAILABLE	3

#define	XAUX_SO_NOTIFY_FLOWSTATE_ID		0xf0 /* tentative */
#define	XAUX_SO_NOTIFY_FLOWSTATE_OK		0
#define	XAUX_SO_NOTIFY_FLOWSTATE_STOP		1
#define	XAUX_SO_FLOWSTATE_TH_OK			2
#define	XAUX_SO_FLOWSTATE_TH_STOP		10

typedef struct xaux_so_class_struct {
	struct xaux_so_struct	*so;	/* back reference to xaux_so_t */
	const char	*classname;	/* aux_name */
	char		*shortname;	/* last part of aux_name */
	int		index;		/* aux_index */
	const char	*extexec;	/* full path of aux_ext executable */
	Window		sowin;		/* aux.so's window */
	Window		extwin;		/* aux_ext's window */
	Atom		atom_classname;	/* "${CLASSNAME}" */
	Atom		atom_sowin;	/* "${CLASSNAME}_sowin" */
	Atom		atom_extwin;	/* "${CLASSNAME}_extwin" */
	Atom		atom_sx;	/* "${CLASSNAME}_sx" */
	Atom		atom_xs;	/* "${CLASSNAME}_xs" */
	xaux_atommng_data_t	*atommng_data;	/* atommng data */
	xaux_so_execmng_data_t	*execmng_data;	/* execmng data */
	xaux_so_setv_state_t	*pending_setv;	/* pending setvalue */
	const CARD16	*utfname;	/* UTF-16 version of classname */
	xaux_so_extstate_t	extstate;	/* state of ext process */
	Bool		started;	/* True between START and DONE */
	aux_icid_t *	ic;		/* IC (tentative) */
	xaux_propq_t	*propq;		/* outgoing property queue */
} xaux_so_class_t;

typedef struct xaux_so_struct {
	xaux_so_class_t	*classes;	/* classes */
} xaux_so_t;

/*
 * return these values as major/minor of extversion
 * when so module can know the external program is not available
 * without actually attempting to execute it.
 * e.g. not exist or insufficient permission
 */
#define XAUX_EXTVERS_MAJOR_NOTAVAIL     -1	/* defined */
#define XAUX_EXTVERS_MINOR_NOTAVAIL     -1	/* not defined but use -1 */

extern const int xaux_so_default_extversion[2];
extern const int xaux_so_setvalue_id_sendversion;
extern const char *xaux_so_extexec_path;

extern aux_method_t VersionQueryAux_methods;

#endif	/* !XAUX_SO_COMMON_H */
