/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <locale.h>

#include "encode.h"
#include "KeyboardConfig.h"

#define MAX_LINE_LEN 		256

/* Used by KeyboardAux */
int 			gKeyboardNum = 0;
VirtualKeyboard  	**gVKB;

void set_ctrlkey_label(VirtualKeyboard *pVKB);
VirtualKeyboard *KeyboardItem_Malloc();
int KeyboardItem_Free(VirtualKeyboard *pVKB);
void Keyboards_Print();

void set_ctrlkey_label(VirtualKeyboard *pVKB)
{
	if (pVKB == NULL) return;

	pVKB->ctrlkey[VK_BackSpace].label_str = BACKSPACE_KEY_LABEL;
	pVKB->ctrlkey[VK_Tab].label_str = TAB_KEY_LABEL;
	pVKB->ctrlkey[VK_Caps_Lock].label_str = CAPS_KEY_LABEL;
	pVKB->ctrlkey[VK_Enter].label_str = ENTER_KEY_LABEL;
	pVKB->ctrlkey[VK_Shift_L].label_str = SHIFT_KEY_LABEL;
	pVKB->ctrlkey[VK_Control_L].label_str = CTRL_KEY_LABEL;
	pVKB->ctrlkey[VK_Alt_L].label_str = ALT_KEY_LABEL;
	pVKB->ctrlkey[VK_space].label_str = SPACE_KEY_LABEL;
	pVKB->ctrlkey[VK_escape].label_str = ESCAPE_KEY_LABEL;
}

/* Add VKB List for KeyboardAux */
VirtualKeyboard *KeyboardItem_Malloc()
{
	VirtualKeyboard *pVKB;
	int i;

	pVKB = (VirtualKeyboard *)calloc(1, sizeof(VirtualKeyboard));
	if (pVKB == NULL) return(NULL);

	pVKB->type  = KEYBOARD_STRING_TYPE;
	pVKB->encode = ENCODE_ERROR;

	set_ctrlkey_label(pVKB);

	for (i=0; i<MAX_BASEKEY_NUM; i++) {
		pVKB->basekey[i].lower_str = NULL;
		pVKB->basekey[i].upper_str = NULL;
	}

	return(pVKB);
}


int KeyboardItem_Free(VirtualKeyboard *pVKB)
{
	int i;

	if (pVKB == NULL) return;

	for (i=0; i<MAX_BASEKEY_NUM; i++) {
		if (pVKB->basekey[i].lower_str) free(pVKB->basekey[i].lower_str);
		if (pVKB->basekey[i].upper_str) free(pVKB->basekey[i].upper_str);
	}

	free((char *)pVKB);
}

int Keyboards_Init()
{
	gKeyboardNum = 0;
	gVKB == NULL;
}

int Keyboards_Done()
{
	int i;

	if (gVKB != NULL) {
		for (i=0; i<gKeyboardNum; i++) {
			KeyboardItem_Free(gVKB[i]);
		}
		free((char *)gVKB);
	}

	gKeyboardNum = 0;
	gVKB = NULL;
}

VirtualKeyboard *Keyboards_Get_Item(int nKeyboardID)
{
	if (gVKB == NULL)
		return(NULL);

	if (nKeyboardID <= -1 || nKeyboardID >= gKeyboardNum)
		return(NULL);

	return(gVKB[nKeyboardID]);
}

VirtualKeyboard *Keyboards_Set_Item(unsigned char *pThai_Keymap)
{
	VirtualKeyboard *pVKB;
	char ch, label_str[128], *tmp_str;
	unsigned char str[2];
	int i;

	/* add PC Keyboard Item */
	pVKB = (VirtualKeyboard *)KeyboardItem_Malloc();
	if (pVKB == NULL) {
		DEBUG_printf("No memory \n");
		return;
	}

	pVKB->type  = KEYBOARD_KEY_TYPE;
	pVKB->encode = ENCODE_ERROR;

	set_ctrlkey_label(pVKB);

	for (i=0; i<MAX_BASEKEY_NUM; i++) {
		tmp_str = KEYLIST_LOWER;
		ch = *(tmp_str + i);
		str[0] = (unsigned char)pThai_Keymap[ch - 0x20];
		str[1] = 0;
		pVKB->basekey[i].lower_str = (char *)strdup((char *)str);

		tmp_str = KEYLIST_UPPER;
		ch = *(tmp_str + i);
		str[0] = (unsigned char)pThai_Keymap[ch - 0x20];
		str[1] = 0;
		pVKB->basekey[i].upper_str = (char *)strdup((char *)str);
	}
		
	return(pVKB);
}

void Keyboards_Print()
{
	VirtualKeyboard *pVKB;
	int i, j;
	char ch, *label_str;

	printf("Keyboards_Print: gKeyboardNum: %d\n", gKeyboardNum);
	label_str = KEYLIST_LOWER;
	for (i=0; i<gKeyboardNum; i++) {
		printf("\n\nKeyboard No %d\n", i);
		pVKB = gVKB[i];
		if (pVKB == NULL) continue;

		for (j=0; j<MAX_BASEKEY_NUM; j++) {
			if (pVKB->basekey[j].lower_str)  {
				printf("%c:#%s#       ", *(label_str + j), pVKB->basekey[j].lower_str);
				if (pVKB->basekey[j].upper_str) 
					printf("#%s#", pVKB->basekey[j].upper_str);
				printf("\n");
			}
		}
	}
}

