/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "wtt.h"

int _TACchclass[256] = {
	/*	   0,   1,   2,   3,   4,   5,   6,   7,
		   8,   9,   A,   B,   C,   D,   E,   F  */

	/*00*/	CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
		CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
	/*10*/	CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
		CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
	/*20*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON, NON,
	/*30*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON, NON,
	/*40*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON, NON,
	/*50*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON, NON,
	/*60*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON, NON,
	/*70*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON,CTRL,
	/*80*/	CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
		CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
	/*90*/	CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
		CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,CTRL,
	/*A0*/	 NON,CONS,CONS,CONS,CONS,CONS,CONS,CONS,
		CONS,CONS,CONS,CONS,CONS,CONS,CONS,CONS,
	/*B0*/	CONS,CONS,CONS,CONS,CONS,CONS,CONS,CONS,
		CONS,CONS,CONS,CONS,CONS,CONS,CONS,CONS,
	/*C0*/	CONS,CONS,CONS,CONS, FV3,CONS, FV3,CONS,
		CONS,CONS,CONS,CONS,CONS,CONS,CONS, NON,
	/*D0*/	 FV1, AV2, FV1, FV1, AV1, AV3, AV2, AV3,
		 BV1, BV2,  BD, NON, NON, NON, NON, NON,
	/*E0*/	  LV,  LV,  LV,  LV,  LV, FV2, NON, AD2,
		TONE,TONE,TONE,TONE, AD1, AD1, AD3, NON,
	/*F0*/	 NON, NON, NON, NON, NON, NON, NON, NON,
		 NON, NON, NON, NON, NON, NON, NON,CTRL
};

/* Table for Thai Cell Manipulation */
char _TAC_celltype_inputcheck[17][17] = {
	/* Cn */ /*	 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   B,   C,   D,   E,   F	    */
	/* Cn-1 00 */	'X', 'A', 'A', 'A', 'A', 'A', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 10 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 20 */	'X', 'A', 'A', 'A', 'A', 'S', 'A', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C',
	     /*	30 */	'X', 'S', 'A', 'S', 'S', 'S', 'S', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 40 */	'X', 'S', 'A', 'S', 'A', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 50 */	'X', 'A', 'A', 'A', 'A', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 60 */	'X', 'A', 'A', 'A', 'S', 'A', 'S', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 70 */	'X', 'A', 'A', 'A', 'A', 'S', 'A', 'R', 'R', 'R', 'C', 'C', 'R', 'R', 'R', 'R', 'R',
	     /* 80 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'C', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* 90 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* A0 */	'X', 'A', 'A', 'A', 'A', 'A', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* B0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* C0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* D0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
	     /* E0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'C', 'C', 'R', 'R', 'R', 'R', 'R',
	     /* F0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'C', 'R', 'R', 'R', 'R', 'R', 'R',
			'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R', 'R', 'R', 'C', 'R', 'C', 'R', 'R', 'R', 'R'
};


char _TAC_cellShptype_inputcheck[28][28] = {
	/* Cn */ /*	 0,  1,  2,  3,  4,  5,  6,  7,
			 8,  9,  A,  B,  C,  D,  E,  F	    */
	/* Cn-1 00 */	'X', 'A', 'A', 'A', 'A', 'A', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 10 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 20 */	'X', 'A', 'A', 'A', 'A', 'S', 'A', 'C',
			'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C',
			'A', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C',
			'C', 'C',
	     /*	30 */	'X', 'S', 'A', 'S', 'S', 'S', 'S', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 40 */	'X', 'S', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 50 */	'X', 'A', 'A', 'A', 'A', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 60 */	'X', 'A', 'A', 'A', 'S', 'A', 'S', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 70 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'C', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'C', 'R', 'R', 'R',
			'R', 'R',
	     /* 80 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* 90 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* A0 */	'X', 'A', 'A', 'A', 'A', 'A', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* B0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* C0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* D0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* E0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'C', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'C', 'R', 'R', 'R',
			'R', 'R',
	     /* F0 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* F1 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'R', 'C', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'R', 'C', 'R', 'R',
			'R', 'R',
	     /* F2 */	'X', 'A', 'A', 'A', 'A', 'S', 'A', 'C',
			'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C',
			'A', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C',
			'C', 'C',
	     /* F3 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'C', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'C', 'R', 'R', 'R',
			'R', 'R',
	     /* F4 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* F5 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* F6 */	'X', 'A', 'A', 'A', 'A', 'A', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* F7 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* F8 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* F9 */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* FA */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'C', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'C', 'R', 'R', 'R',
			'R', 'R',
	     /* FB */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'R', 'R', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'R', 'R', 'R', 'R',
			'R', 'R',
	     /* FC */	'X', 'A', 'A', 'A', 'S', 'S', 'A', 'R',
			'R', 'R', 'C', 'R', 'C', 'R', 'R', 'R', 'R',
			'A', 'R', 'R', 'R', 'C', 'R', 'C', 'R', 'R',
			'R', 'R'
};

unsigned char _TAC_Keymap[97] = {
/*	      !     "     #     $     %     &     '     (     )     *     +     ,     -     .     /     */
/*	\40   \53   \56   \362  \363  \364  \337  \247  \366  \367  \365  \371  \301  \242  \343  \275  */
	0x20, 0x2b, 0x2e, 0xf2, 0xf3, 0xf4, 0xdf, 0xa7, 0xf6, 0xf7, 0xf5, 0xf9, 0xc1, 0xa2, 0xe3, 0xbd, 

/*	0     1     2     3     4     5     6     7     8     9     :     ;     <     =     >     ?     */
/*	\250  \345  \57   \55   \300  \266  \330  \326  \244  \265  \253  \307  \262  \252  \314  \306  */
	0xa8, 0xe5, 0x2f, 0x2d, 0xc0, 0xb6, 0xd8, 0xd6, 0xa4, 0xb5, 0xab, 0xc7, 0xb2, 0xaa, 0xcc, 0xc6, 

/*	@     A     B     C     D     E     F     G     H     I     J     K     L     M     N     O     */
/*	\361  \304  \332  \251  \257  \256  \342  \254  \347  \263  \353  \311  \310  \77   \354  \317  */
	0xf1, 0xc4, 0xda, 0xa9, 0xaf, 0xae, 0xe2, 0xac, 0xe7, 0xb3, 0xeb, 0xc9, 0xc8, 0x3f, 0xec, 0xcf, 

/*	P     Q     R     S     T     U     V     W     X     Y     Z     [     \     ]     ^     _     */
/*	\255  \360  \261  \246  \270  \352  \316  \42   \51   \355  \50   \272  \137  \305  \331  \370  */
	0xad, 0xf0, 0xb1, 0xa6, 0xb8, 0xea, 0xce, 0x22, 0x29, 0xed, 0x28, 0xba, 0x5f, 0xc5, 0xd9, 0xf8, 

/*	`     a     b     c     d     e     f     g     h     i     j     k     l     m     n     o     */
/*	\243  \277  \324  \341  \241  \323  \264  \340  \351  \303  \350  \322  \312  \267  \327  \271  */
	0xa3, 0xbf, 0xd4, 0xe1, 0xa1, 0xd3, 0xb4, 0xe0, 0xe9, 0xc3, 0xe8, 0xd2, 0xca, 0xb7, 0xd7, 0xb9, 

/*	p     q     r     s     t     u     v     w     x     y     z     {     |     }     ~           */
/*	\302  \346  \276  \313  \320  \325  \315  \344  \273  \321  \274  \260  \45   \54   \245  \177  */
	0xc2, 0xe6, 0xbe, 0xcb, 0xd0, 0xd5, 0xcd, 0xe4, 0xbb, 0xd1, 0xbc, 0xb0, 0x25, 0x2c, 0xa5, 0x7f, 
};

int _TAC_Composible[3][5] = {
		/*  'A',	'C',		'S',		'R',		'X'   */
/* Mode 0 */
		{_TAC_ACCEPT,	_TAC_ACCEPT,	_TAC_ACCEPT,	_TAC_ACCEPT,	_TAC_ACCEPT},
/* Mode 1 */
		{_TAC_ACCEPT,	_TAC_ACCEPT,	_TAC_ACCEPT,	_TAC_REJECT,	_TAC_ACCEPT}, 
/* Mode 2 */
		{_TAC_ACCEPT,	_TAC_ACCEPT,	_TAC_REJECT,	_TAC_REJECT,	_TAC_ACCEPT} 
};


int TACcomposible(int mode, unsigned char following_char, unsigned char leading_char)
{
	char ret_check;
	int  following_char_class, leading_char_class, composible_class;
	
	if (mode == MODE_1 || mode == MODE_2) {
		following_char_class = _TACchclass[following_char];
		leading_char_class = _TACchclass[leading_char];
		ret_check = _TAC_celltype_inputcheck[leading_char_class][following_char_class];
		switch (ret_check) {
			case 'A':
				composible_class = 0;
				break;
			case 'C':
				composible_class = 1;
				break;
			case 'S':
				composible_class = 2;
				break;
			case 'R':
				composible_class = 3;
				break;
			case 'X':
				composible_class = 4;
				break;
			default:
				composible_class = 0;
		}
		return(_TAC_Composible[mode][composible_class]);
	} else {
		return(_TAC_ACCEPT);
	}
}

