/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "KeyboardAux.h"

KeyboardAuxData gVKData;

/* Backing pixmap for drawing area */
static GdkPixmap *pixmap = NULL;

/* Create a new backing pixmap of the appropriate size */
static gint configure_event( GtkWidget         *widget,
                             GdkEventConfigure *event )
{
  if (pixmap)
    g_object_unref (pixmap);

  pixmap = gdk_pixmap_new (widget->window,
			   widget->allocation.width,
			   widget->allocation.height,
			   -1);
  gdk_draw_rectangle (pixmap,
		      widget->style->white_gc,
		      TRUE,
		      0, 0,
		      widget->allocation.width,
		      widget->allocation.height);

  return TRUE;
}

/* Redraw the screen from the backing pixmap */
static gint expose_event( GtkWidget      *widget,
                          GdkEventExpose *event )
{
  gdk_draw_drawable (widget->window,
		     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		     pixmap,
		     event->area.x, event->area.y,
		     event->area.x, event->area.y,
		     event->area.width, event->area.height);

  return FALSE;
}

#if 0
void KeyboardAux_DrawKeyboardFrame()
{
	XRectangle rcFrame;
	int nXPos, nYPos, nWidth, nHeight;
	
	nXPos = gVKData.rcKeyboardFrame.x;
	nYPos = gVKData.rcKeyboardFrame.y;
	nWidth = gVKData.rcKeyboardFrame.width;
	nHeight = gVKData.rcKeyboardFrame.height;

	SetRectangle(&rcFrame, 1, 1, nWidth-2, nHeight-2);
	DrawButtonFrame(gVKData.wdtVKArea, &rcFrame, FALSE, 1);
}

void KeyboardAux_DrawKeyButton(int nKeyButtonID, int bPushed)
{
	XRectangle rcFrame;
	Pixel backPixel, forePixel;
	int nWordWidth, nWordHeight;
	int nXPos, nYPos, nWidth, nHeight, i;
	char label_str[2], *keylist_label, *str; 
	XRectangle *KeyButtonFrame = gVKData.KeyButtonFrame;
	VirtualKeyboard *pVKB;
	
	if (gVKB[gVKData.nKeyboardID])
		pVKB = gVKB[gVKData.nKeyboardID];
	else
		pVKB = gVKB[0];

	nXPos = KeyButtonFrame[nKeyButtonID].x;
	nYPos = KeyButtonFrame[nKeyButtonID].y;
	nWidth = KeyButtonFrame[nKeyButtonID].width;
	nHeight = KeyButtonFrame[nKeyButtonID].height;

	XSetForeground(pDisplay, defGC, backPixel);
	XFillRectangle(pDisplay, window, defGC, nXPos, nYPos, nWidth, nHeight);

	XtVaGetValues(gVKData.wdtVKArea, XmNforeground, &forePixel, NULL);
	XSetForeground(pDisplay, defGC,  forePixel);
	XSetBackground(pDisplay, defGC,  backPixel);

	keylist_label = (char *)KEYLIST_LABEL;

	if (nKeyButtonID >= MAX_BASEKEY_NUM) {
		/* if is Control Keys */

		str = pVKB->ctrlkey[nKeyButtonID-MAX_BASEKEY_NUM].label_str;
		if (str == NULL) return;

		xmstr_base = XmStringCreate(str, "TAG1");
		nWordHeight = XmStringHeight(fontList, xmstr_base);
		nWordWidth  = XmStringWidth(fontList, xmstr_base);
		nXPos = nXPos + (nWidth - nWordWidth)/2;
		nYPos = nYPos + (nHeight - nWordHeight)/2;
		XmStringDraw(pDisplay, window, fontList, xmstr_base, defGC, 
				nXPos, nYPos, nWidth, 
				XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_L_TO_R, NULL);
		XmStringFree(xmstr_base);

	} else {
		/* if is Base Keys */

		/* if is PC Keyboard */
		if (gVKData.nKeyboardID != 0 && gVKData.nKeyboardID != gKeyboardNum) {
			label_str[0] = *(keylist_label + nKeyButtonID);
			label_str[1] = 0;

			XmbDrawImageString(pDisplay, window, gVKData.fontset_normal, defGC, 
				nXPos + 3, nYPos + 15, label_str, 1);
		}

		str = pVKB->basekey[nKeyButtonID].lower_str;
		if (str && *str) {
			XmbDrawImageString(pDisplay, window, gVKData.fontset_normal, defGC, 
					nXPos + 3, nYPos + 29,
					str, strlen(str));
		}

		str = pVKB->basekey[nKeyButtonID].upper_str;
		if (str && *str) {
			if (str[1]) {
				/* if is not English Character */
				nXPos = nXPos + nWidth - 13;
			} else {
				/* if is English character */
				nXPos = nXPos + nWidth - 10;
			}
			XmbDrawImageString(pDisplay, window, gVKData.fontset_normal, defGC, 
					nXPos, nYPos + 14,
					str, strlen(str));
		}
	}

	DrawButtonFrame(gVKData.wdtVKArea, &(KeyButtonFrame[nKeyButtonID]), bPushed, 2);
}

void KeyboardAux_DrawAllCtrlKeyButtons()
{
	int nKeyButtonID, nCtrlKeyID, bPushed;

	for (nKeyButtonID=MAX_BASEKEY_NUM; nKeyButtonID<MAX_VK_NUM; nKeyButtonID++) {

		bPushed = FALSE;

		nCtrlKeyID = nKeyButtonID - MAX_BASEKEY_NUM;
		if (nCtrlKeyID == VK_Caps_Lock) {
			bPushed = gVKData.nCapsLockKey_Status ? TRUE : FALSE;
		} else if (nCtrlKeyID == VK_Control_L) {
			bPushed = gVKData.nCtrlKey_Status ? TRUE : FALSE;
		} else if (nCtrlKeyID == VK_Shift_L) {
			bPushed = gVKData.nShiftKey_Status ? TRUE : FALSE;
		} else if (nCtrlKeyID == VK_Alt_L) {
			bPushed = gVKData.nAltKey_Status ? TRUE : FALSE;
		}
		KeyboardAux_DrawKeyButton(nKeyButtonID, bPushed);
	}
}

void KeyboardAux_DrawAllButtons()
{
	int nKeyButtonID, nCtrlKeyID, bPushed;

	KeyboardAux_DrawKeyboardFrame();

	for (nKeyButtonID=0; nKeyButtonID<MAX_VK_NUM; nKeyButtonID++) {
		bPushed = FALSE;
		if (nKeyButtonID >= MAX_BASEKEY_NUM) {
			/* if is Control Keys */
			nCtrlKeyID = nKeyButtonID - MAX_BASEKEY_NUM;
			if (nCtrlKeyID == VK_Caps_Lock) {
				bPushed = gVKData.nCapsLockKey_Status ? TRUE : FALSE;
			} else if (nCtrlKeyID == VK_Control_L) {
				bPushed = gVKData.nCtrlKey_Status ? TRUE : FALSE;
			} else if (nCtrlKeyID == VK_Shift_L) {
				bPushed = gVKData.nShiftKey_Status ? TRUE : FALSE;
			} else if (nCtrlKeyID == VK_Alt_L) {
				bPushed = gVKData.nAltKey_Status ? TRUE : FALSE;
			}
		}
		KeyboardAux_DrawKeyButton(nKeyButtonID, bPushed);
	}
}
#endif

void KeyboardAux_DrawAllButtons(GtkWidget *fixed)
{
	int nKeyButtonID, nCtrlKeyID, bPushed;
	int nXPos, nYPos, nWidth, nHeight;
	GdkRectangle *KeyButtonFrame = gVKData.KeyButtonFrame;
	GtkWidget *button;

	for (nKeyButtonID=0; nKeyButtonID<MAX_VK_NUM; nKeyButtonID++) {
		nXPos = KeyButtonFrame[nKeyButtonID].x;
		nYPos = KeyButtonFrame[nKeyButtonID].y;
		nWidth = KeyButtonFrame[nKeyButtonID].width;
		nHeight = KeyButtonFrame[nKeyButtonID].height;

		button = gtk_button_new();
		g_print("id: %d, nXPos: %d, nYPos: %d, nWidth: %d, nHeight: %d\n", 
			nKeyButtonID, nXPos, nYPos, nWidth, nHeight);
		gtk_widget_set_size_request (button, nWidth, nHeight);
		gtk_fixed_put(GTK_FIXED(fixed), button, nXPos, nYPos);
	}
}

static void redraw_window(GtkWidget *widget)
{
  int i;
  
}
/* Draw a rectangle on the screen */
static void draw_brush( GtkWidget *widget,
                        gdouble    x,
                        gdouble    y)
{
  GdkRectangle update_rect;

  update_rect.x = x - 5;
  update_rect.y = y - 5;
  update_rect.width = 10;
  update_rect.height = 10;
  gdk_draw_rectangle (pixmap,
		      widget->style->black_gc,
		      TRUE,
		      update_rect.x, update_rect.y,
		      update_rect.width, update_rect.height);
  gtk_widget_queue_draw_area (widget, 
		      update_rect.x, update_rect.y,
		      update_rect.width, update_rect.height);
}

static gint button_press_event( GtkWidget      *widget,
                                GdkEventButton *event )
{
  if (event->button == 1 && pixmap != NULL)
    draw_brush (widget, event->x, event->y);

  return TRUE;
}

static gint motion_notify_event( GtkWidget *widget,
                                 GdkEventMotion *event )
{
  int x, y;
  GdkModifierType state;

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = event->x;
      y = event->y;
      state = event->state;
    }
    
  if (state & GDK_BUTTON1_MASK && pixmap != NULL)
    draw_brush (widget, x, y);
  
  return TRUE;
}

void KeyboardAux_InitDimensions()
{
	GdkRectangle *KeyButtonFrame;
	int nXPos, nYPos, nXMargin, nYMargin;
	int nHeight, nWidth, nButtonHeight, nButtonWidth;
	int nFrameHeight, nFrameWidth;
	int nYDelta = 1;
	int i, j;

	KeyButtonFrame = gVKData.KeyButtonFrame;

	nButtonHeight = 32;
	nButtonWidth  = 26;
	nXMargin = 1;
	nYMargin = 1;

	/* layout for the first line */
	nXPos = nXMargin;
	nYPos = nYMargin;

	for (i=VK_quotedbl; i<=VK_equal; i++) {
		nWidth = nButtonWidth;
		KeyButtonFrame[i].x = nXPos;
		KeyButtonFrame[i].y = nYPos;
		KeyButtonFrame[i].width = nWidth;
		KeyButtonFrame[i].height = nButtonHeight;
		nXPos += nWidth;
	} 

	i = VK_BackSpace + MAX_BASEKEY_NUM;
	nWidth = nButtonWidth * 2;
	KeyButtonFrame[i].x = nXPos;
	KeyButtonFrame[i].y = nYPos;
	KeyButtonFrame[i].width = nWidth;
	KeyButtonFrame[i].height = nButtonHeight;

	/* layout for the second line */
	nXPos = nXMargin;
	nYPos += nButtonHeight + nYDelta;

	i = VK_Tab + MAX_BASEKEY_NUM;
	nWidth = nButtonWidth * 3 / 2;
	KeyButtonFrame[i].x = nXPos;
	KeyButtonFrame[i].y = nYPos;
	KeyButtonFrame[i].width = nWidth;
	KeyButtonFrame[i].height = nButtonHeight;
	nXPos += nWidth;

	for (i=VK_q; i<=VK_backslash; i++) {
		nWidth = nButtonWidth;
		if (i == VK_backslash) nWidth = nButtonWidth * 3 / 2;

		KeyButtonFrame[i].x = nXPos;
		KeyButtonFrame[i].y = nYPos;
		KeyButtonFrame[i].width = nWidth;
		KeyButtonFrame[i].height = nButtonHeight;
		nXPos += nWidth;
	} 

	/* layout for the third line */
	nXPos = nXMargin;
	nYPos += nButtonHeight + nYDelta;

	i = VK_Caps_Lock + MAX_BASEKEY_NUM;
	nWidth = nButtonWidth * 2;
	KeyButtonFrame[i].x = nXPos;
	KeyButtonFrame[i].y = nYPos;
	KeyButtonFrame[i].width = nWidth;
	KeyButtonFrame[i].height = nButtonHeight;
	nXPos += nWidth;

	for (i=VK_a; i<=VK_apostrophe; i++) {
		nWidth = nButtonWidth;
		KeyButtonFrame[i].x = nXPos;
		KeyButtonFrame[i].y = nYPos;
		KeyButtonFrame[i].width = nWidth;
		KeyButtonFrame[i].height = nButtonHeight;
		nXPos += nWidth;
	} 

	i = VK_Enter + MAX_BASEKEY_NUM;
	nWidth = nButtonWidth * 2;
	KeyButtonFrame[i].x = nXPos;
	KeyButtonFrame[i].y = nYPos;
	KeyButtonFrame[i].width = nWidth;
	KeyButtonFrame[i].height = nButtonHeight;
	nXPos += nWidth;

	/* layout for the fourth line */
	nXPos = nXMargin;
	nYPos += nButtonHeight + nYDelta;

	i = VK_Shift_L + MAX_BASEKEY_NUM;
	nWidth = nButtonWidth * 5 / 2;
	KeyButtonFrame[i].x = nXPos;
	KeyButtonFrame[i].y = nYPos;
	KeyButtonFrame[i].width = nWidth;
	KeyButtonFrame[i].height = nButtonHeight;
	nXPos += nWidth;

	for (i=VK_z; i<=VK_slash; i++) {
		nWidth = nButtonWidth;
		KeyButtonFrame[i].x = nXPos;
		KeyButtonFrame[i].y = nYPos;
		KeyButtonFrame[i].width = nWidth;
		KeyButtonFrame[i].height = nButtonHeight;
		nXPos += nWidth;
	} 

	/* layout for the fifth line */
	nXPos = nXMargin;
	nYPos += nButtonHeight + nYDelta;

	for (i=VK_Control_L; i<=VK_escape; i++) {
		nWidth = 2 * nButtonWidth;
		if (i == VK_space)  nWidth = 7 * nButtonWidth;
		if (i == VK_escape) nXPos += 2 * nButtonWidth;
		j = i + MAX_BASEKEY_NUM;
		KeyButtonFrame[j].x = nXPos;
		KeyButtonFrame[j].y = nYPos;
		KeyButtonFrame[j].width = nWidth;
		KeyButtonFrame[j].height = nButtonHeight;
		nXPos += nWidth;
	} 

	/* Calculate the frame dimension of the Virtual keyboard */
	nWidth = 15 * nButtonWidth + 2 * nXMargin;
	nHeight = 5 * nButtonHeight + 2 * nYMargin + 4 * nYDelta;

	gVKData.rcKeyboardFrame.width = nWidth + 4;
	gVKData.rcKeyboardFrame.height = nHeight + 4;
}

void quit ()
{
  exit (0);
}

int main( int   argc, 
          char *argv[] )
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *fixed;
  GtkWidget *drawing_area;
  GtkWidget *vbox;

  GtkWidget *button;

  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_POPUP);

  g_signal_connect (G_OBJECT (window), "destroy",
                    G_CALLBACK (quit), NULL);

  /* Create the drawing area */

  KeyboardAux_InitDimensions();
  
  gtk_window_set_default_size(GTK_WINDOW (window), gVKData.rcKeyboardFrame.width, gVKData.rcKeyboardFrame.height);
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);

  frame = gtk_frame_new (0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
  gtk_widget_set_size_request (GTK_WIDGET (frame), 
               gVKData.rcKeyboardFrame.width, gVKData.rcKeyboardFrame.height);
  gtk_container_add (GTK_CONTAINER (window), frame);
                                                                                                                                           
  fixed = gtk_fixed_new ();
  gtk_container_add (GTK_CONTAINER (frame), fixed);

  KeyboardAux_DrawAllButtons(fixed);

#if 0
  drawing_area = gtk_drawing_area_new ();
  gtk_container_add (GTK_CONTAINER (fixed), drawing_area);

  /* Signals used to handle backing pixmap */

  g_signal_connect (G_OBJECT (drawing_area), "expose_event",
		    G_CALLBACK (expose_event), NULL);
  g_signal_connect (G_OBJECT (drawing_area),"configure_event",
		    G_CALLBACK (configure_event), NULL);

  /* Event signals */

/*
  g_signal_connect (G_OBJECT (drawing_area), "motion_notify_event",
		    G_CALLBACK (motion_notify_event), NULL);
  g_signal_connect (G_OBJECT (drawing_area), "button_press_event",
		    G_CALLBACK (button_press_event), NULL);
*/

  gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);
#endif

  gtk_widget_show_all (window);

  gtk_main ();

  return 0;
}
