/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include  <stdio.h>
#include  <string.h>
#include  <stdlib.h>
#include  "GeneType.h"
#include  "PyStatic.h"
#include  "PyBig5.h"

JINT    Big5HzcodeToYjcode(JINT nHzcode);
JINT    GetDyzInfo(JINT nHzcode, JINT* pnDyzYjCode);
JINT    EncodeDyzTo2244(JINT nHzcode, JINT nYjcode);
JINT    FastMatchYinJieStr(CHAR* szPystr);
UCHAR*  RecovDyz2244(UCHAR *szDyz2244);

CHAR    LastChar (JINT nYinjieCode);
CHAR    FirstChar(JINT nYinjieCode);
JINT    ValidButLastChar (JINT nYinjieCode);
JINT    ValidButFirstChar(JINT nYinjieCode);
JINT    ValidAddChar(CHAR ch, JINT nYinjieCode);

/*
**  nHzcode range: [0xA440 ~ 0xC67E] || [0xC940 ~ 0xF87E] || [0x2001 ~ 0x2000 + TOTAL_DYZYINJIE]
**                 [0x2001 ~ 0x2000 + TOTAL_DYZYINJIE] contains 580 DuoYinZi.
**  Lookup table BIG5HZCODETOYJ[] and DYZCODETOYJ[] to return
**  a integer Yinjie code 0~414.
*/
JINT Big5HzcodeToYjcode(JINT nHzcode)
{
	JINT    hi, low;
	JINT    res;
	JINT    t1, t2, t3, t4;
	
	hi  = (nHzcode >> 8) & 0x00FF;
	low = nHzcode & 0x00FF;
	t1  = t2 = t3 = t4 = 0;
	
	res = 0xFFFF;
	if ((hi >= 0xA4) && (hi <= 0xC6) && (low >= 0x40) && (low <= 0xFE))
	{
		if ((low >= 0xA1) && (low <= 0xFE))
			t1 = (hi - 0xA4) * 157 + (low - 0x40) - (0xA1 -0x7E - 1)+ 1;
		else
			t1 = (hi - 0xA4) * 157 + (low - 0x40) + 1;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;

		if (t2 > t3)
			res = (JINT)( (BIG5HZCODETOYJ[t2] >> (32 - t4)) & 0x01FF ) + 
			      (JINT)( (BIG5HZCODETOYJ[t3] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (JINT)( BIG5HZCODETOYJ[t2] >> (32 - t4) ) & 0x01FF;
	}
	else if ((hi >= 0xC9) && (hi <= 0xF9) && (low >= 0x40) && (low <= 0xFE))
	{
		if ((low >= 0xA1) && (low <= 0xFE))
			t1 = (hi - 0xC9) * 157 + (low - 0x40) -(0xA1 -0x7E - 1)+ 1;
		else
			t1 = (hi - 0xC9) * 157 + (low - 0x40) + 1;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;

		if (t2 > t3)
			res = (JINT)( (BIG5HZCODETOYJ[t2 + (9 * 169)] >> (32 - t4)) & 0x01FF ) + 
			      (JINT)( (BIG5HZCODETOYJ[t3 + (9 * 169)] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (JINT)( BIG5HZCODETOYJ[t2 + (9 * 169)] >> (32 - t4) ) & 0x01FF;
	}
	else if ((nHzcode >= 0x2001) && (nHzcode <= 0x2000 + TOTAL_DYZYINJIE))
	{
		t1 = nHzcode - 0x2001;
		res = (JINT) DYZYJCODE[t1];
	}
	else
		res = 0xFFFF;

	if (res == 0x01FF)
		res = 0xFFFF;
		
	return (res);
}


/*
**  Lookup the DYZLIST[580] to see if this nHzcode is a DuoYinZi.
**  index of DYZLIST by High Byte is placed in INDEXOFDYZLIST
**  return: JINT           number of DuoYin, for example: 1, 2, 3  else, 0
**          pnDyzYjCode    yinjiecode include yinjie code
*/
JINT GetDyzInfo(JINT nHzcode, JINT* pnDyzYjCode)
{
	JINT    nHiHzPos, nLowHz;
	JINT    i, j;
	UCHAR   hz[3];
	
	nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xA4;
	nLowHz = nHzcode & 0x00FF;
	
	j = 0;
	for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++)
	{
		if( (DYZLIST[i] & 0x00FF) == nLowHz )
		{
			pnDyzYjCode[j] = DYZYJCODE[i];
			j++;
		}
	}
	
	return (j);
}


/*
**  nHzcode is Normal Hanzi Code defined in BIG5.
**  If nHzcode indicates a DYZ, return 0x2001 ~ (TOTAL_DYZYINJIE - 1 + 0x2001)
**  Else, return 0xFFFF.
*/
JINT EncodeDyzTo2244(JINT nHzcode, JINT nYjcode)
{
	JINT    nHiHzPos, nLowHz;
	JINT    i;
	
	nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xA4;
	if (nHiHzPos < 0)
		return (0xFFFF);
	nLowHz = nHzcode & 0x00FF;
	
	for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++)
	{
		if ( ((DYZLIST[i] & 0x00FF) == nLowHz) && (DYZYJCODE[i] == nYjcode) ) {
			return (i + 0x2001);
		}
	}
	
	return (0xFFFF);
}


/*
**  Lookup the equal string of szPystr in YINJIESTR_CSZ[415].
**  If successfully, return 0~414; otherwise, return -1.
**  If chFirst is 'i' 'u' or 'v', return -1 directly.
*/
JINT FastMatchYinJieStr(CHAR* szPystr)
{
	JINT    i, j, nLen;
	CHAR    chFirst;
	JINT    nFromYJStr, nToYJStr, nShengmuIndex;	

	i = 0;
	nLen = (JINT)strlen(szPystr);
	
	j = 0;
	if (nLen > 0)
	{
		chFirst = szPystr[0];

		if ((chFirst == 'i') || (chFirst == 'u') || (chFirst == 'v'))
			return (-1);

		nFromYJStr = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] ];
		nToYJStr = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] + 1];
		nShengmuIndex = INDEXMAGIC[(JINT)(chFirst - 'a')];
		
		if ((chFirst == 'c') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[3];
			nToYJStr = INDEXSMTOYINJIE[4];
			nShengmuIndex = 3;
		}
		else if ((chFirst == 's') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[19];
			nToYJStr = INDEXSMTOYINJIE[20];
			nShengmuIndex = 19;
		}
		else if ((chFirst == 'z') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[25];
			nToYJStr = INDEXSMTOYINJIE[26];
			nShengmuIndex = 25;
		}

		i = nFromYJStr;
		do {
			j = strcmp (YINJIESTR_CSZ[i], szPystr);
			i++;
		} while ((i < nToYJStr) && (j != 0));
	}
	
	if (j == 0)
		return (i - 1);
	else
		return (-1);
}


/*
**  nYinjieCode Valid from 0 to 414. Return the last
**  character of this YinJie String.
*/
CHAR LastChar(JINT nYinjieCode)
{
	CHAR   res = ' ';		/* SPACE */
	JINT   i = 0;
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		while (YINJIESTR_CSZ[nYinjieCode][i] != '\0')
			i++;
		res = YINJIESTR_CSZ[nYinjieCode][i-1];
	}
	return res;
}

/*
**  nYinjieCode Valid from 0 to 414
*/
CHAR FirstChar(JINT nYinjieCode)
{
	CHAR   res = ' ';		/* SPACE */
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
		res = YINJIESTR_CSZ[nYinjieCode][0];
	return res;
}

/*
**  Valid but the end CHARacter?
**  return 0~414 if valid, else return 0xFFFF
*/
JINT ValidButLastChar(JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i+1])
		{
			szStr[i] = YINJIESTR_CSZ[nYinjieCode][i];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	return 0xFFFF;
}


/*
** Valid add a new CHARacter before it?
** return 0~414 if valid, else return 0xFFFF
*/
JINT ValidAddChar(CHAR ch, JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';

	szStr[0] = ch;
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i])
		{
			szStr[i + 1] = YINJIESTR_CSZ[nYinjieCode][i];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	
	return 0xFFFF;
}


/*
**  Valid but first CHARacter ?
**  return 0~414 if valid, else return 0xFFFF
*/
JINT ValidButFirstChar(JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i+1])
		{
			szStr[i] = YINJIESTR_CSZ[nYinjieCode][i+1];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	
	return 0xFFFF;
}


/*
**  Recover these Hanzi String which encode by GB&Dyz2244 to normal GB
**  Length of returned string is determined by the length of szDyz2244
**
**  This function must be rewritten to process failure of malloc()!!!
*/
UCHAR* RecovDyz2244(UCHAR *szDyz2244)
{
	JINT    i, j, nLen, nHlfLen;
	JINT    nDyzCode, nNormCode;
	static  UCHAR*  szNorm;			/* Used by function RecovDyz2244() */
   
	nLen = strlen((CHAR*)szDyz2244);
	nHlfLen = nLen / 2;

	if(szNorm != NULL)
		free(szNorm);

	szNorm = (UCHAR*)malloc(nLen + 2);
	if (szNorm == NULL)
	{
		fprintf(stderr, "Failed to alloc Memory in function ReconDyz2244\n");
		return szDyz2244;
	}

	for (i = 0; i < (nLen + 2); i++)
		szNorm[i] = '\0';
	
	j = 0;
	for (i = 0; i < nHlfLen; i++)
	{
		nDyzCode = szDyz2244[(2 * i) + 1] + ((JINT)szDyz2244[2 * i] << 8);
		if ((nDyzCode >= 0x2001) && (nDyzCode <= 0x2000 + TOTAL_DYZYINJIE))
		{
			nNormCode         = DYZLIST[nDyzCode - 0x2001];
			szNorm[2 * i]     = (UCHAR)((nNormCode & 0xFF00) >> 8);
			szNorm[2 * i + 1] = (UCHAR)(nNormCode & 0x00FF);
		}
		else
		{
			szNorm[2 * i]      = szDyz2244[2 * i];
			szNorm[2 * i + 1]  = szDyz2244[2 * i + 1];
		}
	}
	
	return (szNorm);
}

