--
-- Selected TOC Entries:
--
\connect - ipac

--
-- remove all tables:
--

DROP SEQUENCE "id";
DROP TABLE "cash";
DROP TABLE "customers";
DROP TABLE "logs";
DROP TABLE "nets";
DROP TABLE "nets_names";
DROP TABLE "raw_logs";
DROP TABLE "services";
DROP TABLE "services_names";
DROP TABLE "tariffs";
DROP TABLE "tariffs_names";

--
-- TOC Entry ID 2 (OID 17723)
--
-- Name: id Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "id" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 4 (OID 17723)
--
-- Name: id Type: ACL Owner: 
--

REVOKE ALL on "id" from PUBLIC;
GRANT ALL on "id" to "postgres";
GRANT ALL on "id" to "apache";
GRANT ALL on "id" to "ipac";

--
-- TOC Entry ID 5 (OID 17725)
--
-- Name: tariffs_names Type: TABLE Owner: postgres
--

CREATE TABLE "tariffs_names" (
	"tariff_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"tariff_name" text,
	Constraint "tariffs_names_pkey" Primary Key ("tariff_id")
);

--
-- TOC Entry ID 6 (OID 17725)
--
-- Name: tariffs_names Type: ACL Owner: 
--

REVOKE ALL on "tariffs_names" from PUBLIC;
GRANT ALL on "tariffs_names" to "postgres";
GRANT ALL on "tariffs_names" to "apache";
GRANT ALL on "tariffs_names" to "ipac";

--
-- TOC Entry ID 7 (OID 17731)
--
-- Name: nets_names Type: TABLE Owner: postgres
--

CREATE TABLE "nets_names" (
	"net_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"net_name" text,
	"glob" integer DEFAULT 100,
	Constraint "nets_names_pkey" Primary Key ("net_id")
);

--
-- TOC Entry ID 8 (OID 17731)
--
-- Name: nets_names Type: ACL Owner: 
--

REVOKE ALL on "nets_names" from PUBLIC;
GRANT ALL on "nets_names" to "postgres";
GRANT ALL on "nets_names" to "apache";
GRANT ALL on "nets_names" to "ipac";

--
-- TOC Entry ID 9 (OID 17737)
--
-- Name: services_names Type: TABLE Owner: postgres
--

CREATE TABLE "services_names" (
	"serv_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"serv_name" text,
	Constraint "services_names_pkey" Primary Key ("serv_id")
);

--
-- TOC Entry ID 10 (OID 17737)
--
-- Name: services_names Type: ACL Owner: 
--

REVOKE ALL on "services_names" from PUBLIC;
GRANT ALL on "services_names" to "postgres";
GRANT ALL on "services_names" to "apache";
GRANT ALL on "services_names" to "ipac";

--
-- TOC Entry ID 11 (OID 17743)
--
-- Name: customers Type: TABLE Owner: postgres
--

CREATE TABLE "customers" (
	"cust_id" integer DEFAULT nextval('id'::text) NOT NULL,
	"login" text NOT NULL,
	"ip_addr" text NOT NULL,
	"name" text,
	"sname" text,
	"phone" text,
	"e_mail" text,
	"address" text,
	"comment" text,
	"pause" boolean DEFAULT 'f',
	"detailed" boolean DEFAULT 'f',
	Constraint "customers_pkey" Primary Key ("cust_id")
);

--
-- TOC Entry ID 12 (OID 17743)
--
-- Name: customers Type: ACL Owner: 
--

REVOKE ALL on "customers" from PUBLIC;
GRANT ALL on "customers" to "postgres";
GRANT ALL on "customers" to "apache";
GRANT ALL on "customers" to "ipac";

--
-- TOC Entry ID 13 (OID 17750)
--
-- Name: services Type: TABLE Owner: postgres
--

CREATE TABLE "services" (
	"serv_id" integer NOT NULL,
	"dest" text,
	"proto" text,
	"tariff_id" integer,
	"net_id" integer,
	"agent" text,
	"sport" text,
	"dport" text,
	"iface" text
);

--
-- TOC Entry ID 14 (OID 17750)
--
-- Name: services Type: ACL Owner: 
--

REVOKE ALL on "services" from PUBLIC;
GRANT ALL on "services" to "postgres";
GRANT ALL on "services" to "apache";
GRANT ALL on "services" to "ipac";

--
-- TOC Entry ID 15 (OID 17761)
--
-- Name: cash Type: TABLE Owner: postgres
--

CREATE TABLE "cash" (
	"cust_id" integer NOT NULL,
	"cash" double precision DEFAULT 0,
	"kredit" double precision DEFAULT 0
);

--
-- TOC Entry ID 16 (OID 17761)
--
-- Name: cash Type: ACL Owner: 
--

REVOKE ALL on "cash" from PUBLIC;
GRANT ALL on "cash" to "postgres";
GRANT ALL on "cash" to "apache";
GRANT ALL on "cash" to "ipac";

--
-- TOC Entry ID 17 (OID 17770)
--
-- Name: nets Type: TABLE Owner: postgres
--

CREATE TABLE "nets" (
	"net_id" integer NOT NULL,
	"ip_net" text
);

--
-- TOC Entry ID 18 (OID 17770)
--
-- Name: nets Type: ACL Owner: 
--

REVOKE ALL on "nets" from PUBLIC;
GRANT ALL on "nets" to "postgres";
GRANT ALL on "nets" to "apache";
GRANT ALL on "nets" to "ipac";

--
-- TOC Entry ID 19 (OID 17775)
--
-- Name: logs Type: TABLE Owner: postgres
--

CREATE TABLE "logs" (
	"rule_name" text NOT NULL,
	"bytes" bigint NOT NULL,
	"pkts" bigint NOT NULL,
	"that_time" bigint NOT NULL,
	Constraint "logs_pkey" Primary Key ("that_time", "rule_name")
);

--
-- TOC Entry ID 20 (OID 17775)
--
-- Name: logs Type: ACL Owner: 
--

REVOKE ALL on "logs" from PUBLIC;
GRANT ALL on "logs" to "postgres";
GRANT ALL on "logs" to "apache";
GRANT ALL on "logs" to "ipac";

--
-- TOC Entry ID 21 (OID 17781)
--
-- Name: tariffs Type: TABLE Owner: postgres
--

CREATE TABLE "tariffs" (
	"cust_id" integer NOT NULL,
	"tariff_id" integer NOT NULL,
	"price" double precision,
	"pr_type" integer,
	"last_paid" timestamp with time zone DEFAULT now(),
	"active_nocash" integer,
	"detailed" boolean DEFAULT 'f'::bool
);

--
-- TOC Entry ID 22 (OID 17781)
--
-- Name: tariffs Type: ACL Owner: 
--

REVOKE ALL on "tariffs" from PUBLIC;
GRANT ALL on "tariffs" to "postgres";
GRANT ALL on "tariffs" to "apache";
GRANT ALL on "tariffs" to "ipac";

--
-- TOC Entry ID 23 (OID 17795)
--
-- Name: raw_logs Type: TABLE Owner: postgres
--

CREATE TABLE "raw_logs" (
	"source" text,
	"destination" text,
	"proto" text,
	"sport" text,
	"dport" text,
	"time" text NOT NULL,
	"len" text
);

--
-- TOC Entry ID 24 (OID 17795)
--
-- Name: raw_logs Type: ACL Owner: 
--

REVOKE ALL on "raw_logs" from PUBLIC;
GRANT ALL on "raw_logs" to "postgres";
GRANT ALL on "raw_logs" to "apache";
GRANT ALL on "raw_logs" to "ipac";

--
-- TOC Entry ID 25 (OID 17749)
--
-- Name: "customers_login_key" Type: INDEX Owner: postgres
--

CREATE UNIQUE INDEX customers_login_key ON customers USING btree (login);

--
-- TOC Entry ID 26 (OID 17763)
--
-- Name: "cash_cust_id_key" Type: INDEX Owner: postgres
--

CREATE UNIQUE INDEX cash_cust_id_key ON cash USING btree (cust_id);

--
-- TOC Entry ID 45 (OID 17756)
--
-- Name: "RI_ConstraintTrigger_17755" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "services"  FROM "nets_names" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'services', 'nets_names', 'UNSPECIFIED', 'net_id', 'net_id');

--
-- TOC Entry ID 39 (OID 17758)
--
-- Name: "RI_ConstraintTrigger_17757" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "nets_names"  FROM "services" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'services', 'nets_names', 'UNSPECIFIED', 'net_id', 'net_id');

--
-- TOC Entry ID 40 (OID 17760)
--
-- Name: "RI_ConstraintTrigger_17759" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "nets_names"  FROM "services" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'services', 'nets_names', 'UNSPECIFIED', 'net_id', 'net_id');

--
-- TOC Entry ID 46 (OID 17765)
--
-- Name: "RI_ConstraintTrigger_17764" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "cash"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'cash', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 41 (OID 17767)
--
-- Name: "RI_ConstraintTrigger_17766" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "customers"  FROM "cash" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'cash', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 42 (OID 17769)
--
-- Name: "RI_ConstraintTrigger_17768" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "customers"  FROM "cash" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'cash', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 47 (OID 17784)
--
-- Name: "RI_ConstraintTrigger_17783" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "tariffs"  FROM "customers" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'tariffs', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 43 (OID 17786)
--
-- Name: "RI_ConstraintTrigger_17785" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "customers"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'tariffs', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 44 (OID 17788)
--
-- Name: "RI_ConstraintTrigger_17787" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "customers"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'tariffs', 'customers', 'UNSPECIFIED', 'cust_id', 'cust_id');

--
-- TOC Entry ID 48 (OID 17790)
--
-- Name: "RI_ConstraintTrigger_17789" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER INSERT OR UPDATE ON "tariffs"  FROM "tariffs_names" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_check_ins" ('<unnamed>', 'tariffs', 'tariffs_names', 'UNSPECIFIED', 'tariff_id', 'tariff_id');

--
-- TOC Entry ID 37 (OID 17792)
--
-- Name: "RI_ConstraintTrigger_17791" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER DELETE ON "tariffs_names"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_del" ('<unnamed>', 'tariffs', 'tariffs_names', 'UNSPECIFIED', 'tariff_id', 'tariff_id');

--
-- TOC Entry ID 38 (OID 17794)
--
-- Name: "RI_ConstraintTrigger_17793" Type: TRIGGER Owner: postgres
--

CREATE CONSTRAINT TRIGGER "<unnamed>" AFTER UPDATE ON "tariffs_names"  FROM "tariffs" NOT DEFERRABLE INITIALLY IMMEDIATE FOR EACH ROW EXECUTE PROCEDURE "RI_FKey_cascade_upd" ('<unnamed>', 'tariffs', 'tariffs_names', 'UNSPECIFIED', 'tariff_id', 'tariff_id');

--
-- TOC Entry ID 3 (OID 17723)
--
-- Name: id Type: SEQUENCE SET Owner: 
--

SELECT setval ('"id"', 1, true);

