/****************************************************************************
 *                            ShmDFIOHeader.h
 *
 * Author: Matthew Ballance
 * Desc:   Represents the 
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SHM_DFIO_HEADER_H
#define INCLUDED_SHM_DFIO_HEADER_H
#include "types.h"

typedef Uint32    ShmDFIOPtr;

typedef struct ShmDFIOHeader {
    Uint32        d_mappedSize;
    Uint32        d_usedSize;

    /*** Only used for windows, but we keep it for correct
     *** structure size...
     ***/
    Uint32        d_mapIndex;

    Uint32        d_owner;
    Uint32        d_locks;

    ShmDFIOPtr    d_traceList;
    Uint32        d_traceCount;

    Uint32        d_changeInfo;

    Uint32        d_blockSize;
    Int32         d_timeUnit;
    Uint32        d_maxTime;
};

#endif /* INCLUDED_SHM_DFIO_HEADER_H */

