/****************************************************************************
 *                             ShmDFIOWriter.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements the writer end of the DFIO
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SHM_DFIO_WRITER_H
#define INCLUDED_SHM_DFIO_WRITER_H
#include "DFIO.h"
#include "ShmDFIO.h"
#include "ShmDFIOFile.h"
#include "ShmDFIOHeader.h"

/********************************************************************/
/** \class ShmDFIOWriter
 *  \brief Implementation of the ShmDFIO that writes files
 ********************************************************************/
class ShmDFIOWriter : public ShmDFIO {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************/
        /** ShmDFIOWriter()
         ************************************************************/
        ShmDFIOWriter(
                Tcl_Interp       *interp,
                int               argc,
                char            **argv);

        /************************************************************/
        /** ~ShmDFIOWriter()
         ************************************************************/
        virtual ~ShmDFIOWriter();

        /************************************************************
         * newTrace()
         ************************************************************/
        virtual DFIOTrace *newTrace(
                Char       *name,
                Uint32      rows,
                Uint32      msb,
                Uint32      lsb,
                Uint32      traceType);

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

};

#endif /* INCLUDED_SHM_DFIO_WRITER_H */
