/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
/**
 *
 */
public class EventKey extends Boxed 
{
	public EventKey(int handle) {
		this.handle = handle;
	}
	
	public int getKeyVal() {
		return EventKey.getKeyval(handle);
	}
	
	public String getString() {
		return EventKey.getString(handle);
	}
	
	public int getGroup() {
		return EventKey.getGroup(handle);
	}
	
	public int getLength() {
		return EventKey.getLength(handle);
	}
	
	public int getState() {
		return EventKey.getState(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (int obj);
    native static final protected int getWindow (int obj);
    native static final protected boolean getSendEvent (int obj);
    native static final protected int getTime (int obj);
    native static final protected int getState (int obj);
    native static final protected int getKeyval (int obj);
    native static final protected int getLength (int obj);
    native static final protected String getString (int obj);
    native static final protected int getHardwareKeycode (int obj);
    native static final protected int getGroup (int obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

