
/*
 * regexp.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_REGEXP_C
#define DIALOGS_REGEXP_C

#include "typedefs.h"
#include "regexp.h"

bool Match::MatchPattern (const char *text,const char *pattern)
{
   return (match (text,pattern) == MATCH_VALID ) ? TRUE : FALSE;
}

bool Match::IsPattern (const char *pattern)
{
   while (*pattern)
	 {
		switch (*pattern++)
		  {
		   case '?':
		   case '*':
		   case '[':
		   case '\\':
			 return TRUE;
		  }
	 }
   return FALSE;
}

bool Match::IsValidPattern (const char *pattern,int *error_type)
{
   *error_type = PATTERN_VALID;
   while (*pattern)
	 {
		switch (*pattern)
		  {
		   case '\\':
			 if (!*++pattern)
			   {
				  *error_type = PATTERN_ESC;
				  return FALSE;
			   }
			 pattern++;
			 break;
		   case '[':
			 pattern++;
			 if (*pattern == ']')
			   {
				  *error_type = PATTERN_EMPTY;
				  return FALSE;
			   }
			 if (!*pattern)
			   {
				  *error_type = PATTERN_CLOSE;
				  return FALSE;
			   }
			 while (*pattern != ']')
			   {
				  if (*pattern == '\\')
					{
					   pattern++;
					   if (!*pattern++)
						 {
							*error_type = PATTERN_ESC;
							return FALSE;
						 }
					}
				  else  pattern++;
				  if (!*pattern)
					{
					   *error_type = PATTERN_CLOSE;
					   return FALSE;
					}
				  if (*pattern == '-')
					{
					   if (!*++pattern || *pattern == ']')
						 {
							*error_type = PATTERN_RANGE;
							return FALSE;
						 }
					   else
						 {
							if (*pattern == '\\') pattern++;
							if (!*pattern++)
							  {
								 *error_type = PATTERN_ESC;
								 return FALSE;
							  }
						 }
					}
			   }
			 break;
		   case '*':
		   case '?':
		   default:
			 pattern++;
			 break;
		  }
	 }
   return TRUE;
}

int Match::match (const char *text,const char *pattern)
{
   char range_start,range_end;
   bool invert,member_match,loop;
   for (; *pattern; pattern++, text++)
	 {
		if (!*text) return ( *pattern == '*' && *++pattern == '\0' ) ? MATCH_VALID : MATCH_ABORT;
		switch (*pattern)
		  {
		   case '?':
			 break;
		   case '*':
			 return match_after_star (text,pattern);
		   case '[':
			 pattern++;
			 invert = FALSE;
			 if (*pattern == '!' || *pattern == '^')
			   {
				  invert = TRUE;
				  pattern++;
			   }
			 if (*pattern == ']') return MATCH_PATTERN;
			 member_match = FALSE;
			 loop = TRUE;
			 while (loop)
			   {
				  if (*pattern == ']')
					{
					   loop = FALSE;
					   continue;
					}
				  if (*pattern == '\\')
					range_start = range_end = *++pattern;
				  else
					range_start = range_end = *pattern;
				  if (!*pattern) return MATCH_PATTERN;
				  if (*++pattern == '-')
					{
					   range_end = *++pattern;
					   if (range_end == '\0' || range_end == ']') return MATCH_PATTERN;
					   if (range_end == '\\')
						 {
							range_end = *++pattern;
							if (!range_end) return MATCH_PATTERN;
						 }
					   pattern++;
					}
				  if (range_start < range_end)
					{
					   if (*text >= range_start && *text <= range_end)
						 {
							member_match = TRUE;
							loop = FALSE;
						 }
					}
				  else
					{
					   if (*text >= range_end && *text <= range_start)
						 {
							member_match = TRUE;
							loop = FALSE;
						 }
					}
			   }
			 if ((invert && member_match) || !(invert || member_match)) return MATCH_RANGE;
			 if (member_match)
			   {
				  while (*pattern != ']')
					{
					   if (!*pattern) return MATCH_PATTERN;
					   if (*pattern == '\\')
						 {
							pattern++;
							if (!*pattern) return MATCH_PATTERN;
						 }
					   pattern++;
					}
			   }
			 break;
		   case '\\':
			 pattern++;
			 if (!*pattern) return MATCH_PATTERN;
		   default:
			 if (*pattern != *text) return MATCH_LITERAL;
		  }
	 }
   if (*text) return MATCH_END; else  return MATCH_VALID;
}


int Match::match_after_star (const char *text,const char *pattern)
{
   int matchpattern = 0;
   char nextpattern;
   while (*pattern == '?' || *pattern == '*')
	 {
		if (*pattern == '?') if (!*text++) return MATCH_ABORT;
		pattern++;
	 }
   if (!*pattern) return MATCH_VALID;
   nextpattern = *pattern;
   if (nextpattern == '\\')
	 {
		nextpattern = pattern[1];
		if (!nextpattern) return MATCH_PATTERN;
	 }
   do
	 {
		if (nextpattern == *text || nextpattern == '[') matchpattern = match (text,pattern);
		if (!*text++) matchpattern = MATCH_ABORT;
	 }
   while (matchpattern != MATCH_VALID &&
		  matchpattern != MATCH_ABORT &&
		  matchpattern != MATCH_PATTERN);
   return matchpattern;
}

#endif
