/***************************************************************************
                          definition.h  -  description
                             -------------------
    begin                : Mit Nov 20 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/

#ifndef DEFINITION_H
#define DEFINITION_H

#include "labelutils.h"
#include <qmap.h>
#include <qstring.h>

#define I2S(x) QString::number(x)

class QFile;
class QPaintDevice;
class QString;
class QStringList;
class QSqlQuery;
class Measurements;
/** @short A label definition;
  *
  * Represents a label definition. The definition is either read from
  * a SQL database or from a text file on the harddisk.
  * This class supports also writing new label definitions.
  * After you selected a definition, you can retrieve its measurements.
  *
  * @author Dominik Seichter
  */
class Definition : private LabelUtils {
    public:
        Definition();
        Definition( int label_def_id );
        Definition( const QString & label_def_id );
        Definition( const QString & producer, const QString & type );
        ~Definition();

        void setId( const QString & label_def_id );
        void setId( int label_def_id );

        // never delete measurements!
        Measurements* getMeasurements() const;

        static int write( Measurements* c, QString type, QString producer );
        static int getClosest( const QString & producer, const QString & type );
        
        static const QStringList getProducers();
        static const QStringList getTypes( QString producer );        
        /** reread the list of producers, because it has changed
          * mapType is also cleared and reread when necessary.
          */
        static void updateProducer();

        int getId() const { return id; }
        const QString getProducer() const { return producer; }
        const QString getType() const { return type; }

    private:
        void init( const QString & label_def_id );
        void getFileMeasurements( const QString & label_def_id );

        static int writeSQL( Measurements* c, QString type, QString producer );
        static int writeFile( Measurements* c, QString type, QString producer );
        
        static bool showFileError();
        static bool openFile();
        static QStringList* listProducers;
        static QMap<QString,QStringList> mapTypes;
        static QFile* file;
        static QByteArray* array;

        int id;
        QString producer;
        QString type;
        Measurements* m;
        bool locked;
        static bool nodefmsg;
};

#endif
