/***************************************************************************
                          navview.cpp  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Richard Moore
    email                : rich@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qobjectlist.h>
#include <qobjectdict.h>

#include "navview.h"
#include "navviewitem.h"

NavView::NavView(QWidget *parent, const char *name ) : QListView(parent,name)
{
  addColumn( "Name" );
  addColumn( "Type" );

  setRootIsDecorated( true );
  setAllColumnsShowFocus( true );

  connect( this, SIGNAL( selectionChanged( QListViewItem * ) ),
	   this, SLOT( selectItem( QListViewItem * ) ) );
  connect( this, SIGNAL( expanded( QListViewItem * ) ),
	   this, SLOT( expandItem( QListViewItem * ) ) );
}

NavView::~NavView(){
}

void NavView::buildTree()
{
  //
  // Add root QObjects
  //
  const QObjectList *roots = QObject::objectTrees();
  QObjectListIt it( *roots );

  QObject * obj;
  while ( (obj=it.current()) != 0 ) {
    ++it;
    new NavViewItem( this, obj );
  }
}

void NavView::selectItem( QListViewItem *i )
{
  NavViewItem *ni = (NavViewItem *) i;
  emit selected( ni->data );
}

void NavView::expandItem( QListViewItem *i )
{
  NavViewItem *ni = (NavViewItem *) i;

  //
  // Clear old data.
  //
  while( ni->childCount() )
    delete ni->firstChild();

  //
  // Populate
  //
  const QObjectList *kids = ni->data->children();
  if ( !kids )
    return;

  QObject * obj;
  QObjectListIt it( *kids );
  while ( (obj=it.current()) != 0 ) {
    ++it;
    new NavViewItem( ni, obj );
  }
}
#include "navview.moc"
