/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TEXTPROPERTIES_H
#define TEXTPROPERTIES_H

#include "TextProperties_base.h"

class DDataItem;
class QShowEvent;
class TextProperties : public TextProperties_base
{
    Q_OBJECT

    public:
	TextProperties( QWidget* parent, const char* name=0);
	~TextProperties();
	void showEvent(QShowEvent *);
	void activate();

    public slots:
        void setCurrentItem(DDataItem*);
	void updateItem();
	void itemChanged(int);

    private:
	DDataItem *m_lastitem;
};

#endif // TEXTPROPERTIES_H
