/***************************************************************************
                       iptruleoption.h  -  description
                          -------------------
 begin                : Mon Feb 4 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTRULEOPTION_H
#define IPTRULEOPTION_H

#include "netfilterobject.h"

// QT
#include <qstring.h>
#include <qstringlist.h>
#include <qdict.h>

#include <qdom.h>

#define MAXOPTNUM 10

class KMFDoc;
class IPTRule;

/**
  * class IPTRuleOption
  *
  */
class IPTRuleOption : public NetfilterObject {
	static QDict<QStringList>* m_dict_option_strings;
	static QDict<QStringList>* m_dict_gui_strings;
	static QPtrList<QString>* m_known_types;
	static bool m_created_dict;
	/** Public methods: */
public:
	IPTRuleOption(  IPTRule* = 0  );
	~IPTRuleOption();

	/**
	  * restor config from an xml sniplet
	  * @param domfragment
	  *        xml sniplet
	  */
	void loadXML( const QDomDocument& );

	void setRule( int id );
	int ruleID() { return m_rule_id; };

	/** */
	void reset();

	/** */
	bool isEmpty();

	/** Return DomDocument representing this rule() */
	const QDomDocument& getDOMTree( );

	/** */
	const QString& toString( );

	/** Set Option Type */
	void setOptionType( const QString& );

	/** */
	const QString& getOptionType() const {
		return m_option_type;
	};

	/** */
	bool isTargetOption() const {
		return m_target_option;
	};

	IPTRule* rule() const {
		return m_rule;
	};
	
	void setTargetOption( bool );

	void loadValues( QStringList );
	const QStringList& getValues();

	static QDict<QStringList>* getOptionStringDict();
	static QDict<QStringList>* getGUIStringDict();
	static QPtrList<QString>* getAvailableOptionTypes();
	static void registerRuleOption(const QString& type, const QStringList& options, const QStringList& gui_strings);

	/**Attributes: */
private:
	//     KMFDoc *m_doc;
	IPTRule *m_rule;
	/**  */
	QString m_option_type;

	/** Send changed signal to parent object */
	void changed();

	/**  */
	int m_rule_id;

	/** */
	bool m_target_option;

	/** */
// 	bool m_used;

	/** */
	QString m_values[ MAXOPTNUM ];

	/** Holding the attribute names for the values of the rule option. */
	int m_max_undos;


private:  //helper
	static void createOptionDict();
};


#endif // IPTRULEOPTION_H
