/***************************************************************************
                        kmfruleeditorprotocol.cpp  -  description
                           -------------------
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditorprotocol.h"

// kde includes
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kapplication.h>

// qt includes
#include <qlayout.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qgroupbox.h>

// project includes
#include "../core/iptrule.h"
#include "kmfportwidget.h"
#include "kmfmultiportwidget.h"

KMFRuleEditorProtocol::KMFRuleEditorProtocol( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorProtocol( parent, name, fl ) {
	use_multiport = false;
	cb_icmp_type->insertItem( "echo-request" );
	cb_icmp_type->insertItem( "echo-reply" );
	cb_icmp_type->insertItem( "source-quench" );
	cb_icmp_type->insertItem( "router-advertisement" );
	cb_icmp_type->insertItem( "router-solicitation" );
	cb_icmp_type->insertItem( "timestamp-request" );
	cb_icmp_type->insertItem( "timestamp-reply" );
	cb_icmp_type->insertItem( "address-mask-request" );
	cb_icmp_type->insertItem( "address-mask-reply" );
	cb_icmp_type->insertItem( "destination-unreachable" );
	cb_icmp_type->insertItem( "network-unreachable" );
	cb_icmp_type->insertItem( "host-unreachable" );
	cb_icmp_type->insertItem( "protocol-unreachable" );
	cb_icmp_type->insertItem( "port-unreachable" );
	cb_icmp_type->insertItem( "fragmentation-needed" );
	cb_icmp_type->insertItem( "source-route-failed" );
	cb_icmp_type->insertItem( "network-unknown" );
	cb_icmp_type->insertItem( "host-unknown" );
	cb_icmp_type->insertItem( "network-prohibited" );
	cb_icmp_type->insertItem( "host-prohibited" );
	cb_icmp_type->insertItem( "TOS-network-unreachable" );
	cb_icmp_type->insertItem( "TOS-host-unreachable" );
	cb_icmp_type->insertItem( "communication-prohibited" );
	cb_icmp_type->insertItem( "host-precedence-violation" );
	cb_icmp_type->insertItem( "precedence-cutoff" );
	cb_icmp_type->insertItem( "redirect" );
	cb_icmp_type->insertItem( "network-redirect" );
	cb_icmp_type->insertItem( "host-redirect" );
	cb_icmp_type->insertItem( "TOS-network-redirect" );
	cb_icmp_type->insertItem( "TOS-host-redirect" );
	cb_icmp_type->insertItem( "time-exceeded" );
	cb_icmp_type->insertItem( "ttl-zero-during-transit" );
	cb_icmp_type->insertItem( "ttl-zero-during-reassembly" );
	cb_icmp_type->insertItem( "parameter-problem" );
	cb_icmp_type->insertItem( "ip-header-bad" );
	cb_icmp_type->insertItem( "required-option-missing" );

	mpwid = new KMFMultiPortWidget( tab_multiport, "mpwid" );
	connect( mpwid, SIGNAL( sigMultiPortChanged( bool ) ), this, SLOT( toggleMultiPort( bool ) ) );

	pw_dest_port = new KMFPortWidget( tab_ports, "pw_dest_port" );
	pw_dest_port->setEnabled( false );
	connect( c_dest_port, SIGNAL( toggled( bool ) ) , pw_dest_port, SLOT( setEnabled( bool ) ) );

	pw_src_port = new KMFPortWidget( tab_ports, "pw_src_port" );
	pw_src_port->setEnabled( false );
	connect( c_src_port, SIGNAL( toggled( bool ) ) , pw_src_port, SLOT( setEnabled( bool ) ) );

	tab_multiportLayout->addMultiCellWidget( mpwid, 0, 0, 2, 2 );
	tab_portsLayout->addWidget( pw_src_port, 1, 1 );
	tab_portsLayout->addWidget( pw_dest_port, 2, 1 );

	connect( c_udp, SIGNAL( toggled( bool ) ), this, SLOT( toggleUdpRule( bool ) ) );
	connect( c_icmp, SIGNAL( toggled( bool ) ), this, SLOT( toggleIcmpRule( bool ) ) );
	connect( c_tcp, SIGNAL( toggled( bool ) ), this, SLOT( toggleTcpRule( bool ) ) );
	tabWidget->setTabEnabled( tab_ports, false );
	tabWidget->setTabEnabled( tab_multiport, false );
	tabWidget->setTabEnabled( tab_icmp, false );
	tabWidget->setTabEnabled( tab_special_tcp, false );

	tabWidget->setEnabled( false );
	adjustSize();
}

KMFRuleEditorProtocol::~KMFRuleEditorProtocol() {}

bool KMFRuleEditorProtocol::multiportEnabled() const {
	return use_multiport;
}

void KMFRuleEditorProtocol::toggleMultiPort( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleMultiPort(" << enabled << ")" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_ports, false );
		if ( c_tcp->isChecked() )
			tabWidget->setTabEnabled( tab_special_tcp, false );

		use_multiport = true;
	} else {
		tabWidget->setTabEnabled( tab_ports, true );
		if ( c_tcp->isChecked() )
			tabWidget->setTabEnabled( tab_special_tcp, true );

		use_multiport = false;
	}
}

void KMFRuleEditorProtocol::toggleUdpRule( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleMultiPort(bool)" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_ports, true );
		tabWidget->setTabEnabled( tab_multiport, true );
		tabWidget->setTabEnabled( tab_icmp, false );
		tabWidget->setTabEnabled( tab_special_tcp, false );
	} else {
		//    tabWidget->setTabEnabled(tab_ports,true);
		//		tabWidget->setTabEnabled(tab_multi_port,true);
		//		tabWidget->setTabEnabled(tab_special_tcp,true);
	}
}
void KMFRuleEditorProtocol::toggleTcpRule( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleTcpRule(bool)" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_ports, true );
		tabWidget->setTabEnabled( tab_multiport, true );
		tabWidget->setTabEnabled( tab_special_tcp, true );
		tabWidget->setTabEnabled( tab_icmp, false );
	} else {
		//		tabWidget->setTabEnabled(tab_icmp,true);
	}
}

void KMFRuleEditorProtocol::toggleIcmpRule( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleIcmpRule(bool)" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_icmp, true );
		tabWidget->setTabEnabled( tab_special_tcp, false );
		tabWidget->setTabEnabled( tab_ports, false );
		tabWidget->setTabEnabled( tab_multiport, false );
	} else {
		//		tabWidget->setTabEnabled(tab_special_tcp,true);
		//		tabWidget->setTabEnabled(tab_ports,true);
		//    tabWidget->setTabEnabled(tab_multiport,false);
	}
}

void KMFRuleEditorProtocol::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditorProtocol::loadRule(IPTRule* rule)" << endl;
	toggleMultiPort( false );
	toggleTcpRule( false );
	pw_dest_port->reset();
	pw_dest_port->reset();
	mpwid->reset();
	c_all->setChecked( false );
	c_icmp->setChecked( false );
	c_udp->setChecked( false );
	c_tcp->setChecked( false );
	c_src_port->setChecked( false );
	c_dest_port->setChecked( false );
	c_icmp_type->setChecked( false );
	c_inv_icmp->setChecked( false );
	c_inv_prot->setChecked( false );
	cb_icmp_type->setCurrentItem( 0 );
	c_tcp_flags->setChecked( false );
	c_inv_flags->setChecked( false );
	c_tcp_option->setChecked( false );
	c_inv_tcp_option->setChecked( false );
	sb_tcp_option_num->setValue( 0 );
	c_all_mask->setChecked( false );
	c_none_mask->setChecked( false );
	c_syn_mask->setChecked( false );
	c_ack_mask->setChecked( false );
	c_fin_mask->setChecked( false );
	c_urg_mask->setChecked( false );
	c_rst_mask->setChecked( false );
	c_psh_mask->setChecked( false );
	c_all_comp->setChecked( false );
	c_none_comp->setChecked( false );
	c_syn_comp->setChecked( false );
	c_ack_comp->setChecked( false );
	c_fin_comp->setChecked( false );
	c_urg_comp->setChecked( false );
	c_rst_comp->setChecked( false );
	c_psh_comp->setChecked( false );



	kdDebug() << "void KMFRuleEditorProtocol::loadRule(IPTRule* rule)" << endl;
	QPtrList<QPtrList<QString> > opt_list = rule->ruleOptions();
	for ( uint j = 0;j < opt_list.count();j++ ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		options = opt_list.at( j );
		if ( true /*options->count()>0*/ ) {
			QString * opt = options->at( 0 );
			if ( *opt == "tcp" ) {
				toggleMultiPort( false );
				toggleTcpRule( true );
				c_tcp->setChecked( true );
				c_all->setEnabled( false );
				c_udp->setEnabled( false );
				c_icmp->setEnabled( false );
				tabWidget->setEnabled( true );


				for ( uint i = 1;i < options->count();i++ ) {
					kdDebug() << "OPTION VALUE: " << *options->at( i ) << endl;
					if ( i == 1 ) {  // src port
						QString cmd = *options->at( i );
						if ( !cmd.isEmpty() ) {
							kdDebug() << "Option Value -sport: " << cmd << endl;
							c_src_port->setChecked( true );
							pw_src_port->loadPortString( cmd );
						}
					}
					if ( i == 2 ) {
						QString cmd = *options->at( i );
						if ( !cmd.isEmpty() ) {
							kdDebug() << "Option Value -dport: " << cmd << endl;
							c_dest_port->setChecked( true );
							pw_dest_port->loadPortString( cmd );
						}
					}
					if ( i == 3 ) {  	 // tcp flags
						QString cmd = *options->at( i );
						if ( !cmd.isEmpty() ) {
							kdDebug() << "Option Value --tcp-flags: " << cmd << endl;
							gb_mask->setEnabled( true );
							gb_comp->setEnabled( true );
							c_tcp_flags->setChecked( true );
							int delim = cmd.find( " " );
							if ( cmd.startsWith( "! " ) ) {
								c_inv_flags->setChecked( true );
								cmd = cmd.right( cmd.length() - 2 );
							}
							delim = cmd.find( " " );
							kdDebug() << "found Whitespace at " << delim << endl;
							QString mask_lst = cmd.left( delim );
							kdDebug() << "Flags for Mask: " << mask_lst << endl;
							QString comp_lst = cmd.right( cmd.length() - delim );
							kdDebug() << "Flags for Comp: " << comp_lst << endl;

							if ( mask_lst.contains( "SYN" ) > 0 )
								c_syn_mask->setChecked( true );
							if ( mask_lst.contains( "ACK" ) > 0 )
								c_ack_mask->setChecked( true );
							if ( mask_lst.contains( "FIN" ) > 0 )
								c_fin_mask->setChecked( true );
							if ( mask_lst.contains( "RST" ) > 0 )
								c_rst_mask->setChecked( true );
							if ( mask_lst.contains( "URG" ) > 0 )
								c_urg_mask->setChecked( true );
							if ( mask_lst.contains( "PSH" ) > 0 )
								c_psh_mask->setChecked( true );
							if ( mask_lst.contains( "NONE" ) > 0 )
								c_none_mask->setChecked( true );
							if ( mask_lst.contains( "ALL" ) > 0 )
								c_all_mask->setChecked( true );

							if ( comp_lst.contains( "SYN" ) > 0 )
								c_syn_comp->setChecked( true );
							if ( comp_lst.contains( "ACK" ) > 0 )
								c_ack_comp->setChecked( true );
							if ( comp_lst.contains( "FIN" ) > 0 )
								c_fin_comp->setChecked( true );
							if ( comp_lst.contains( "RST" ) > 0 )
								c_rst_comp->setChecked( true );
							if ( comp_lst.contains( "URG" ) > 0 )
								c_urg_comp->setChecked( true );
							if ( comp_lst.contains( "PSH" ) > 0 )
								c_psh_comp->setChecked( true );
							if ( comp_lst.contains( "NONE" ) > 0 )
								c_none_comp->setChecked( true );
							if ( comp_lst.contains( "ALL" ) > 0 )
								c_all_comp->setChecked( true );
						}

					}
					if ( i == 4 ) {  	 // tcp options
						QString cmd = *options->at( i );
						if ( !cmd.isEmpty() ) {
							kdDebug() << "Option Value --tcp-options: " << cmd << endl;
							c_tcp_option->setChecked( true );
							sb_tcp_option_num->setEnabled( true );
							if ( cmd.startsWith( "! " ) ) {
								c_inv_tcp_option->setChecked( true );
								cmd = cmd.right( cmd.length() - 2 );
							}
							int val = cmd.toInt();
							sb_tcp_option_num->setValue( val );

						}
					}
				}
			}

			if ( *opt == "udp" ) {
				toggleMultiPort( false );
				c_udp->setChecked( true );
				c_all->setEnabled( false );
				c_tcp->setEnabled( false );
				c_icmp->setEnabled( false );
				tabWidget->setEnabled( true );
				toggleUdpRule( true );

				for ( uint i = 1;i < options->count();i++ ) {
					kdDebug() << "OPTION VALUE: " << *options->at( i ) << endl;
					if ( i == 1 ) {  // src port
						QString cmd = *options->at( i );
						if ( !cmd.isEmpty() ) {
							kdDebug() << "Option Value -sport: " << cmd << endl;
							c_src_port->setChecked( true );
							pw_src_port->loadPortString( cmd );
						}
					}
					if ( i == 2 ) {
						QString cmd = *options->at( i );
						if ( !cmd.isEmpty() ) {
							kdDebug() << "Option Value -dport: " << cmd << endl;
							c_dest_port->setChecked( true );
							pw_dest_port->loadPortString( cmd );
						}
					}
				}
			}

			if ( *opt == "tcp_src_multiport" || *opt == "tcp_dest_multiport" || *opt == "tcp_equal_multiport" ||
			        *opt == "udp_src_multiport" || *opt == "udp_dest_multiport" || *opt == "udp_equal_multiport" ) {
				if ( *opt == "tcp_src_multiport" || *opt == "tcp_dest_multiport" || *opt == "tcp_equal_multiport" ) {
					c_tcp->setChecked( true );
					c_udp->setEnabled( false );
				} else {
					c_tcp->setEnabled( false );
					c_udp->setChecked( true );
				}


				for ( uint i = 1;i < options->count();i++ ) {
					kdDebug() << "OPTION VALUE: " << *options->at( i ) << endl;
					if ( i == 1 ) {  // src port
						c_all->setEnabled( false );
						c_icmp->setEnabled( false );
						tabWidget->setEnabled( true );
						toggleMultiPort( true );
						tabWidget->showPage( tab_multiport );
						QString cmd = *options->at( i );
						if ( *opt == "tcp_src_multiport" || *opt == "udp_src_multiport" )
							mpwid->setType( "src" );
						if ( *opt == "tcp_dest_multiport" || *opt == "udp_dest_multiport" )
							mpwid->setType( "dest" );
						if ( *opt == "tcp_equal_multiport" || *opt == "udp_equal_multiport" )
							mpwid->setType( "equ" );
						mpwid->loadPortString( cmd );
						kdDebug() << "Option Value -sport: " << cmd << endl;
					}
				}
			}
			if ( *opt == "all_prot" ) {
				c_all->animateClick();
			}
			if ( *opt == "icmp" ) {
				c_icmp->animateClick();
				for ( uint i = 0;i < options->count();i++ ) {
					kdDebug() << "OPTION VALUE: " << *options->at( i ) << endl;
					if ( i == 1 ) {
						QString cmd = *options->at( i );
						kdDebug() << "Option Value -sport: " << cmd << endl;
						if ( cmd.startsWith( "! " ) ) {
							c_inv_icmp->setChecked( true );
							cmd = cmd.right( cmd.length() - 2 );
						}
						c_icmp_type->setChecked( true );
						cb_icmp_type->setEditText( cmd );
					}
				}
			}
			//   		if (*opt == "other" ) {
			//	   		c_all->animateClick();
			//   			for (int i = 0;i<options->count();i++) {
			//   		  	kdDebug() << "OPTION VALUE: " << *options->at(i) << endl;
			//   		  	if (i == 1) {  // src port
			//   		  		QString cmd = *options->at(i);
			//
			//   		  	  kdDebug() << "Option Value -sport: " << cmd << endl;
			//   		  	  if (cmd.startsWith("!")) {
			//   						c_inv_prot->setChecked(true);
			//   					}
			//  		  	}
			//   		  }
			//   		}
		}
	}
}

void KMFRuleEditorProtocol::accept() {
	kdDebug() << "void KMFRuleEditorProtocol::accept()" << endl;
	// delete options++++++++++++++++++++++++++++++++
	QString* option_str = new QString( "all_prot" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "tcp" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "udp" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "icmp" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "other_prot" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "tcp_src_multiport" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "tcp_dest_multiport" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "tcp_equal_multiport" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "udp_src_multiport" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "udp_dest_multiport" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	option_str = new QString( "udp_equal_multiport" );
	// 	curr_rule->delRuleOption(*option_str);
	emit sigDelRuleOpt( option_str );
	///////////////////////////////////////////////////////
	// set options ++++++++++++++++++++++++++++++++++++++++
	if ( c_tcp->isChecked() ) {
		kdDebug() << "You like a TCP Rule" << endl;
		// Multiport options ++++++++++++++++++++++++++++
		if ( multiportEnabled() ) {
			kdDebug() << "Multiport Rule" << endl;
			QString *s = new QString( "" );
			mpwid->getPortString( s );
			QString src = *s;
			kdDebug() << "Found Multiport:" << src << endl;
			if ( !src.isEmpty() ) {
				QString type = "";
				type = mpwid->type();
				QString* name;
				if ( type == "src" )
					name = new QString( "tcp_src_multiport" );
				else if ( type == "dest" )
					name = new QString( "tcp_dest_multiport" );
				else if ( type == "equ" )
					name = new QString( "tcp_equal_multiport" );
				else
					name = new QString( "" );
				QString* opt = new QString( src );
				QPtrList<QString>* options = new QPtrList<QString>;
				options->append( opt );
				emit sigAddRuleOpt( name, options );
				kdDebug() << "Found Option Value: " << *opt << endl;
			}
		}
		//////////////////////////////////////////////////////////////
		// Start normal tcp options
		else {
			QString src = "";
			QString dest = "";
			QString flags = "";
			QString tcp_option = "";

			if ( c_src_port->isChecked() ) {
				QString * s = new QString( "" );
				pw_src_port->getPortString( s );
				if ( !s->isEmpty() )
					src = *s;
				if ( src.isEmpty() )
					return ;
			}
			if ( c_dest_port->isChecked() ) {
				QString * s = new QString( "" );
				pw_dest_port->getPortString( s );
				if ( !s->isEmpty() )
					dest = *s;
				if ( dest.isEmpty() )
					return ;
			}
			if ( c_tcp_flags->isChecked() ) {
				if ( c_inv_flags->isChecked() ) {
					flags.prepend( "! " );
				}
				QString mask = "";
				if ( ( c_all_comp->isChecked() || c_none_comp->isChecked() || c_syn_comp->isChecked() || c_fin_comp->isChecked() || c_ack_comp->isChecked() || c_rst_comp->isChecked() || c_urg_comp->isChecked() || c_psh_comp->isChecked() ) &&
				        ( c_all_mask->isChecked() || c_none_mask->isChecked() || c_syn_mask->isChecked() || c_fin_mask->isChecked() || c_ack_mask->isChecked() || c_rst_mask->isChecked() || c_urg_mask->isChecked() || c_psh_mask->isChecked() ) ) {
					if ( c_all_mask->isChecked() )
						mask.append( "ALL" );
					if ( c_none_mask->isChecked() )
						mask.append( "NONE" );
					if ( !c_all_mask->isChecked() && !c_none_mask->isChecked() ) {
						if ( c_syn_mask->isChecked() )
							mask.append( ",SYN" );
						if ( c_fin_mask->isChecked() )
							mask.append( ",FIN" );
						if ( c_ack_mask->isChecked() )
							mask.append( ",ACK" );
						if ( c_rst_mask->isChecked() )
							mask.append( ",RST" );
						if ( c_psh_mask->isChecked() )
							mask.append( ",PSH" );
						if ( c_urg_mask->isChecked() )
							mask.append( ",URG" );
						if ( mask.startsWith( "," ) )
							mask = mask.right( mask.length() - 1 );
					}
					QString comp = "";
					if ( c_all_comp->isChecked() )
						comp.append( "ALL" );
					if ( c_none_comp->isChecked() )
						comp.append( "NONE" );
					if ( !c_all_comp->isChecked() && !c_none_comp->isChecked() ) {
						if ( c_syn_comp->isChecked() )
							comp.append( ",SYN" );
						if ( c_fin_comp->isChecked() )
							comp.append( ",FIN" );
						if ( c_ack_comp->isChecked() )
							comp.append( ",ACK" );
						if ( c_rst_comp->isChecked() )
							comp.append( ",RST" );
						if ( c_psh_comp->isChecked() )
							comp.append( ",PSH" );
						if ( c_urg_comp->isChecked() )
							comp.append( ",URG" );
					}

					if ( comp.startsWith( "," ) )
						comp = comp.right( comp.length() - 1 );
					flags.append( mask );
					flags.append( " " );
					flags.append( comp );
				} else {
					KMessageBox::sorry( this, i18n( "<qt><p>You need to select the TCP flags you like to "
					                                "check and those your rule should match.</qt>" ) );

					return ;
				}
			}
			if ( c_tcp_option->isChecked() ) {
				tcp_option = sb_tcp_option_num->text();
				if ( c_inv_tcp_option->isChecked() ) {
					tcp_option.prepend( "! " );
				}
			}

			if ( src.isEmpty() && dest.isEmpty() && flags.isEmpty() && tcp_option.isEmpty() ) {
				QPtrList<QString>* options = new QPtrList<QString>;
				QString* name = new QString( "tcp" );
				QString* opt = new QString( "nil" );
				options->append( opt );
				emit sigAddRuleOpt( name, options );
			} else {
				QPtrList<QString>* options = new QPtrList<QString>;
				QString* name = new QString( "tcp" );
				QString* opt = new QString( src );
				options->append( opt );
				opt = new QString( dest );
				options->append( opt );
				opt = new QString( flags );
				options->append( opt );
				opt = new QString( tcp_option );
				options->append( opt );
				emit sigAddRuleOpt( name, options );
			}
		}
	}
	//////////////////////////////////////////////////////////////////
	// start udp options
	if ( c_udp->isChecked() ) {
		kdDebug() << "You like a UDP Rule" << endl;
		if ( multiportEnabled() ) {
			kdDebug() << "You like a UDP - multiport Rule" << endl;
			QString *s = new QString( "" );
			mpwid->getPortString( s );
			QString src = *s;
			kdDebug() << "Found Multiport:" << src << endl;
			if ( !src.isEmpty() ) {
				QString type = "";
				type = mpwid->type();
				QString* name;
				if ( type == "src" )
					name = new QString( "udp_src_multiport" );
				else if ( type == "dest" )
					name = new QString( "udp_dest_multiport" );
				else if ( type == "equ" )
					name = new QString( "udp_equal_multiport" );
				else
					name = new QString( "" );

				QString* opt = new QString( src );
				QPtrList<QString>* options = new QPtrList<QString>;
				options->append( opt );
				emit sigAddRuleOpt( name, options );
				kdDebug() << "Found Option Value: " << *opt << endl;
			} else {
				return ;
			}
		}
		// start normal udp options
		else {
			QString src = "";
			QString dest = "";

			if ( c_src_port->isChecked() ) {
				QString * s = new QString( "" );
				pw_src_port->getPortString( s );
				if ( !s->isEmpty() )
					src = *s;
				if ( src.isEmpty() )
					return ;
			}
			if ( c_dest_port->isChecked() ) {
				QString * s = new QString( "" );
				pw_dest_port->getPortString( s );
				if ( !s->isEmpty() )
					dest = *s;
				if ( dest.isEmpty() )
					return ;
			}

			if ( src.isEmpty() && dest.isEmpty() ) {
				QPtrList<QString>* options = new QPtrList<QString>;
				QString* name = new QString( "udp" );
				QString* opt = new QString( src );
				options->append( opt );
				opt = new QString( dest );
				options->append( opt );
				emit sigAddRuleOpt( name, options );
			} else {
				QPtrList<QString>* options = new QPtrList<QString>;
				QString* name = new QString( "udp" );
				QString* opt = new QString( src );
				options->append( opt );
				opt = new QString( dest );
				options->append( opt );
				emit sigAddRuleOpt( name, options );
			}
		}
	}

	if ( c_icmp->isChecked() ) {
		kdDebug() << "You like a ICMP Rule" << endl;
		QString* name = new QString( "icmp" );
		QString* opt = new QString( "" );
		if ( c_icmp_type->isChecked() ) {
			opt = new QString( cb_icmp_type->currentText() );
			if ( c_inv_icmp->isChecked() ) {
				opt->prepend( "! " );
			}
		}
		QPtrList<QString>* options = new QPtrList<QString>;
		options->append( opt );
		emit sigAddRuleOpt( name, options );
	}

	if ( c_all->isChecked() ) {
		kdDebug() << "You like an ALL Rule" << endl;
		QString* name = new QString( "all_prot" );
		QString* opt = new QString( " " );
		QPtrList<QString>* options = new QPtrList<QString>;
		options->append( opt );
		emit sigAddRuleOpt( name, options );
	}

	emit sigDocumentChanged();
	// QDialog::accept();
}

void KMFRuleEditorProtocol::slotHelp() {
	kapp->invokeHelp( "protocol" );
}
void KMFRuleEditorProtocol::reject() {
	emit sigHideMe();
}

#include "kmfruleeditorprotocol.moc"
