/***************************************************************************
                       kmfrulelvitem.cpp  -  description
                          -------------------
 begin                : Tue Aug 13 2002
 copyright            : (C) 2002 by animal
 email                : animal@shit.orphi.iki
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfrulelvitem.h" 
// QT includes
#include <qstring.h>
#include <qlistview.h> 
// KDE includes
#include <kdebug.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <klistview.h>
#include <klocale.h>
// project includes
#include "core/iptrule.h"

KMFRuleLVItem::KMFRuleLVItem( QListView *parent, IPTRule* rule ) : KListViewItem( parent ) {
	m_top = false;
	loadRule( rule );
}
KMFRuleLVItem::KMFRuleLVItem( QListViewItem *parent, IPTRule* rule ) : KListViewItem( parent ) {
	m_top = false;
	loadRule( rule );
}
KMFRuleLVItem::KMFRuleLVItem( QListView *parent, QListViewItem* after, IPTRule* rule ) : KListViewItem( parent, after ) {
	m_top = false;
	loadRule( rule );
}
KMFRuleLVItem::KMFRuleLVItem( QListViewItem *parent, QListViewItem* after, IPTRule* rule ) : KListViewItem( parent, after ) {
	m_top = false;
	loadRule( rule );
}

KMFRuleLVItem::~KMFRuleLVItem() {}

void KMFRuleLVItem::loadRule( IPTRule *rule ) {
	//	kdDebug() << "void KMFRuleLVItem::loadRule(IPTRule *rule)" << endl;
	m_rule = rule;
}

void KMFRuleLVItem::setupView() {
	if ( m_rule == 0 )
		return ;
	loadIcons();
	createRuleView( this, m_rule );
	setDragEnabled( true );
	setDropEnabled( true );
	setOpen( false );
}

void KMFRuleLVItem::clearView() {
//	QPixmap *icon_null = new QPixmap;
//	setPixmap( 0, icon_null );
//	setPixmap( 1, icon_null );
//	setPixmap( 2, icon_null );
	setText( 0, "" );
	setText( 1, "" );
	setText( 2, "" );
	QListViewItem *next = firstChild();
	while ( next != 0 ) {
		takeItem( next );
		next = firstChild();
	}
}

void KMFRuleLVItem::createRuleView( QListViewItem* item, IPTRule* rule ) {
	m_top = true;
	QPixmap icon_null;
	QString rule_name = rule->name();
	QString rule_target = rule->target();
	QString rule_cmd = rule->cmdString();

	QString rule_nr = "";
	if ( rule->customRule() && rule->enabled() ) {
		rule_nr = rule_nr + "Custom ";
	}
	if ( !rule->enabled() ) {
		rule_nr = rule_nr + "Disabled ";
	}
	rule_nr = rule_nr + "Rule:";
	item->setPixmap( 0, icon_rule );
	item->setText( 0, rule_nr );
	if ( !rule->enabled() )
		item->setPixmap( 1, icon_disabled );
	else
		item->setPixmap( 1, icon_null );
	item->setText( 1, QString::null );
	item->setPixmap( 2, icon_null );
	item->setText( 2, rule_name );
	setRenameEnabled( 2, true );

	//	kdDebug() << "There are options defined for the rule " << endl;
	KMFRuleLVItem* item_target = new KMFRuleLVItem( item, 0, rule );
	item_target->setPixmap( 0, icon_target );
	item_target->setText( 2, rule_target );
	if ( rule_target == "ACCEPT" ) {
		item_target->setPixmap( 1, icon_accept );
	} else if ( rule_target == "DROP" ) {
		item_target->setPixmap( 1, icon_drop );
	} else if ( rule_target == "LOG" ) {
		item_target->setPixmap( 1, icon_log );
	} else if ( rule_target == "REJECT" ) {
		item_target->setPixmap( 1, icon_reject );
	} else if ( rule_target == "RETURN" ) {
		item_target->setPixmap( 1, icon_return );
	} else if ( rule_target == "QUEUE" ) {
		item_target->setPixmap( 1, icon_queue );
	}

	KMFRuleLVItem* item_cmd = new KMFRuleLVItem( item, 0, rule );
	item_cmd->setMultiLinesEnabled( true );
	item_cmd->setText( 0, i18n( "Cmd:" ) );
	item_cmd->setPixmap( 1, icon_cmd );
	item_cmd->setText( 2, rule_cmd );

	QPtrList<QPtrList<QString> >& target_options = rule->ruleTargetOptions();
	if ( !target_options.isEmpty() ) {
		item_target->setOpen( true );
		for ( uint j = 0;j < target_options.count();j++ ) {
			QPtrList<QString>* option_values = target_options.at( j );
			if ( !option_values->isEmpty() ) {
				QString opt_str = *option_values->at( 0 );
				//				kdDebug() << "Found Option: " << opt_str << endl;
				QString opt = opt_str;

				if ( opt == "log_tcp_seq" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Log TCP sequence:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "log_tcp_options" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Log TCP options:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "log_ip_options" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Log IP options:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "log_prefix" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Log prefix:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "set_mark" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Set mark:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "reject_type" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Reject with type:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "set_tos" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Set Tos:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "snat" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "To IP/port:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "dnat" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "To IP/port:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "masq_to_ports" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "To port(s):" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "custom_option" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_target, rule );
					item_opt->setText( 0, i18n( "Custom option:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
			}
		}
	}

	QPtrList<QPtrList<QString> >& options = rule->ruleOptions();
	if ( !options.isEmpty() ) {
		kdDebug() << "There are options defined for the rule " << endl;
		KMFRuleLVItem* item_filter = new KMFRuleLVItem( item, 0, rule );
		item_filter->setPixmap( 0, icon_filter );
		item_filter->setOpen( true );
		for ( uint j = 0;j < options.count();j++ ) {
			QPtrList<QString>* option_values = options.at( j );
			if ( !option_values->isEmpty() ) {
				QString opt_str = *option_values->at( 0 );
				//				kdDebug() << "Found Option: " << opt_str << endl;
				QString opt = opt_str;
				//				kdDebug() << "Found Option Name: " << opt << endl;
				if ( opt == "tcp" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "TCP" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Src. port:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
							if ( i == 2 ) {
								KMFRuleLVItem * item_dport = new KMFRuleLVItem( item_opt, rule );
								item_dport->setText( 0, i18n( "Dest. port:" ) );
								QString dest_port = *option_values->at( 2 );
								item_dport->setText( 2, dest_port );
							}
							if ( i == 3 ) {
								KMFRuleLVItem * item_flags = new KMFRuleLVItem( item_opt, rule );
								item_flags->setText( 0, i18n( "TCP flags:" ) );
								QString flags = *option_values->at( 3 );
								item_flags->setText( 2, flags );
							}
							if ( i == 4 ) {
								KMFRuleLVItem * item_o = new KMFRuleLVItem( item_opt, rule );
								item_o->setText( 0, i18n( "TCP option no.:" ) );
								QString op = *option_values->at( 4 );
								item_o->setText( 1, op );
							}
						}
					}
				}
				if ( opt == "udp" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "UDP" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Src. port:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
							if ( i == 2 ) {
								KMFRuleLVItem * item_dport = new KMFRuleLVItem( item_opt, rule );
								item_dport->setText( 0, i18n( "Dest. port:" ) );
								QString dest_port = *option_values->at( 2 );
								item_dport->setText( 2, dest_port );
							}
						}
					}
				}
				if ( opt == "icmp" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "ICMP" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "ICMP type:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "all_prot" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "ALL" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "ICMP type:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "udp_src_multiport" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "UDP (multiport match extension)" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Src. ports:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "udp_dest_multiport" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "UDP (multiport match extension)" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Dest. ports:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "udp_equal_multiport" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "UDP (multiport match extension)" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Equal. ports:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "tcp_src_multiport" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "TCP (multiport match extension)" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->loadRule( rule );
								item_sport->setText( 0, i18n( "Src. ports:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "tcp_dest_multiport" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "TCP (multiport match extension)" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Dest. ports:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "tcp_equal_multiport" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Protocol:" ) );
					item_opt->setText( 2, i18n( "TCP (multiport match extension)" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Equal. ports:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
						}
					}
				}
				if ( opt == "src_ip" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Src. IP:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "dest_ip" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Dest. IP:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "mac" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Src. MAC:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "state" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "State:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "limit" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Limit:" ) );
					item_opt->setOpen( true );
					for ( int i = option_values->count() - 1; i > 0;i-- ) {
						if ( !option_values->at( i ) ->isEmpty() ) {
							if ( i == 1 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Limit:" ) );
								QString src_port = *option_values->at( 1 );
								item_sport->setText( 2, src_port );
							}
							if ( i == 2 ) {
								KMFRuleLVItem * item_sport = new KMFRuleLVItem( item_opt, rule );
								item_sport->setText( 0, i18n( "Burst:" ) );
								QString src_port = *option_values->at( 2 );
								item_sport->setText( 2, src_port );
							}

						}
					}
				}
				if ( opt == "tos" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "TOS (Type of service):" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "frag" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Match Fragments" ) );
					if ( option_values->count() > 1 && !option_values->at( 1 ) ->isNull() ) {
						if ( option_values->at( 1 ) ->startsWith( "! " ) ) {
							item_opt->setText( 2, i18n( "Inverted" ) );
						}
					}
				}
				if ( opt == "in_int" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Incoming interface:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "out_int" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Outgoing interface:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
				if ( opt == "custom_option" ) {
					KMFRuleLVItem * item_opt = new KMFRuleLVItem( item_filter, rule );
					item_opt->setText( 0, i18n( "Custom option:" ) );
					item_opt->setText( 2, *option_values->at( 1 ) );
				}
			}
		}
	}
  if ( rule->logging() ) {
		KMFRuleLVItem* item_log = new KMFRuleLVItem( item, 0, rule );
		item_log->setText( 0, i18n( "Logging:" ) );
		item_log->setPixmap( 1, icon_log );
		item_log->setText( 2, i18n( "Logging matching Packets" ) );
	}
	if ( rule->description() != "" ) {
		KMFRuleLVItem* item_desc = new KMFRuleLVItem( item, 0, rule );
    item_desc->setMultiLinesEnabled( true );
		item_desc->setText( 0, i18n( "Documentation:" ) );
		item_desc->setPixmap( 1, icon_rename );
		item_desc->setText( 2, rule->description());
	} 
	item->setOpen( true );

}
void KMFRuleLVItem::loadIcons() {
	kdDebug() << "void KMFRuleLVItem::loadIcons()" << endl;
	KIconLoader *loader = KGlobal::iconLoader();
	QString icon_name;

	icon_name = "up";
	icon_up = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "down";
	icon_down = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "ereaser";
	icon_del = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filenew";
	icon_new = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "edit";
	icon_edit = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "nfs_unmount";
	icon_rule = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "text";
	icon_rename = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "view_tree";
	icon_chain = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "reject";
	icon_reject = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "target";
	icon_target = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "stop";
	icon_drop = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_accept = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filesaveas";
	icon_log = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "undo";
	icon_return = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editclear";
	icon_cmd = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "pipe";
	icon_queue = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_cancel";
	icon_disabled = loader->loadIcon( icon_name, KIcon::Small );
}


IPTRule* KMFRuleLVItem::rule() {
	//  kdDebug() << "IPTRule* KMFRuleLVItem::rule()" << endl;
	return m_rule;
}

