// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include "hk_kdexmlexportdialog.h"
#include <hk_database.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kapplication.h>
#include <kconfig.h>

hk_kdexmlexportdialog::hk_kdexmlexportdialog(const QString& table, QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdexmlexportdialogbase( parent, name, modal, fl ), hk_reportxml()
{
    p_tablename=table;
    p_datasourcetype=dt_table;
    maindocumenttagfield->setText(QString::fromLocal8Bit(maindocumenttag().c_str()));
    rowelementfield->setText(QString::fromLocal8Bit(rowtag().c_str()));
    structurefield->setChecked(includetableschema());
    structurefield->setText(i18n("include tableschema?"));
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("XMLExport");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
}


hk_kdexmlexportdialog::~hk_kdexmlexportdialog()
{
// no need to delete child widgets, Qt does it all for us
}


void hk_kdexmlexportdialog::ok_clicked()
{
    set_filename(filefield->text().local8Bit().data());
    long ds=new_datasource(tablenamefield->currentText().local8Bit().data(),p_datasourcetype);
    set_presentationdatasource(ds);
    set_maindocumenttag(maindocumenttagfield->text().local8Bit().data());
    set_rowtag(rowelementfield->text().local8Bit().data());
    set_includetableschema(structurefield->isChecked());
    set_fieldname_as_attribute(attributefield->isChecked()?fieldnameattribute:fieldname);
    if ( execute()) accept();
KConfig* c=kapp->config();
  c->setGroup("XMLExport");
  c->writeEntry("Geometry",geometry());
}


void hk_kdexmlexportdialog::buttons_enabled()
{
    if (    !filefield->text().isEmpty()
        &&!maindocumenttagfield->text().isEmpty()
        &&!rowelementfield->text().isEmpty()
        &&!tablenamefield->currentText().isEmpty()
        )
        buttonOk->setEnabled(true);
    else buttonOk->setEnabled(false);
}


void hk_kdexmlexportdialog::filebutton_clicked()
{
    p_file = KFileDialog::getOpenFileName( QString::null, QString::null, this,i18n("Select a XML file"));
    filefield->setText(p_file);
}


void hk_kdexmlexportdialog::set_usetablelist()
{
    p_datasourcetype=dt_table;
    set_datasourcelist();
}

void hk_kdexmlexportdialog::set_useviewlist()
{
    p_datasourcetype=dt_view;
    set_datasourcelist();
}

void hk_kdexmlexportdialog::set_usequerylist()
{
    p_datasourcetype=dt_query;
    set_datasourcelist();
}




void hk_kdexmlexportdialog::set_datasourcelist(void)
{
    tablenamefield->clear();
    hk_database* p_db=database();
    if (p_db==NULL)return ;
    vector<hk_string>* tbl=p_db->tablelist();
    switch (p_datasourcetype)
    {
    case dt_table:
    {
        //tbl already set as default;
        tablenamelabel->setText( i18n("Tablename:"  ) );
	break;
    }
    case dt_query:
    {
        tbl=p_db->querylist();
        tablenamelabel->setText( i18n("Queryname:"  ) );
	break;
    }
    case dt_view:
    {
        tbl=p_db->viewlist();
        tablenamelabel->setText( i18n("Viewname:"  ) );
	break;
    }
    }
    vector<hk_string>::iterator it;
    if (tbl!=NULL)
    {
        for(it=tbl->begin();it!=tbl->end();it++)
        {
            tablenamefield->insertItem(QString::fromLocal8Bit((*it).c_str()));
            if (!p_tablename.isEmpty()&& p_tablename==(*it).c_str()) tablenamefield->setCurrentItem(tablenamefield->count()-1);
        }
    }

}
