/****************************************************************************
                          kanalog.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/

#ifndef KANALOG_H
#define KANALOG_H

#include <qframe.h>

//#include <qpainter.h>
//#include <qfont.h>

  struct zvyraz {
    float start,end;
    int barva;
    };

class QPainter;
class QFont;
    

/**
 * Tato trida zajistuje zobrazeni analogovych mericich panelu.
 *
 * @author Daniel Prynych
 * @short Analogove merici panely
 * @version 0.5
*/
class KAnalog : public QFrame  {
  Q_OBJECT
  public:

/**
 * Konstruktor - vytvori objekt pro analogovy merici panel o rozmerech 130 x 130 bodu
 *
 * Pokud je potreba vykreslit nebo prekreslit panel je nutno zavolat funkci repaint,
 * ostatni funkce ji zavolaji sami pokud je run = TRUE.
 *
 * @param Astart Je pocatecni hodnota stupnice.
 * @param Aend Je koncova hodnota stupnice.
 * @param type Udava typ meraku 1 - kruh , 2 - prava vysec, 3 - horni vysec.
 * @param numberItem Udava pocet rozdeleni stupnice.
 * @param numberInItem Udava pocet rozdeleni velkeho dilku stupnice na mensi casti.
 * @param Afinger Urcuje barvu rucicky a jeji hodnoty.
 * @param Ascale Urcuje barvu stupnice.
 * @param Afont Urcuje barvu textu.
 * @param analogFonts Urcuje font pro text a stupnici.
 * @since  0.3
 **/
  KAnalog(QWidget *parent = 0, const char *name = 0, int Astart = 0, int Aend = 100, int type = 1, int numberItem = 5, int numberInItem = 0, QColor Afinger = Qt::black, QColor Ascale = Qt::black, QColor AFont = Qt::black, QFont *analogFonts = 0L);

/**
 * Destruktor
 * @since  0.1
 **/
  ~KAnalog();

/**
 * Nastavi text dolni a horni text na panelu.
 *
 * @param text_down Udava "dolni" text, obvykle co je mereno.
 * @param text_up Udava "horni" text, obvykle merna jednotka.
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 **/
  void setText (QString text_down, QString text_up, bool run=false);



/**
 * Inicializuje devet zakladnich barev pro mezikruzi.
 *
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 **/
  void setDefaultArcColor(bool run=false);


/**
 * Nastavi zakladni barvu pro mezikruzi.
 *
 * @param reg Poradove cislo barvy (barevneho registru).
 * @param color Barva na kterou bude nastaven registr barvy.
 *
 * @since  0.1
 **/
  void setArcColor(int reg, QColor color );


        
/**
 * Vybarvi cast stupnice zadanou barvou.
 * Barevne casti se barvy postupne, v poradi jak jsou zadany, mohou se prekryvat.
 * Je mozno nabarvit jen 5 casti !!
 *
 * @param a Urcuje pocatecni uhel.
 * @param b Urcuje koncovy uhel.
 * @param color Urcuje barvu.
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.2
 **/
  void addArc (float a, float b, int regColor, bool run=false);



/**
 * Zrusi vybarveni stupnice.
 *
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 **/
  void delArc (bool run=false);



/**
 * Nastavi rozsah stupnice.
 *
 * @param Astart Urcuje pocatecni hodnotu stupnice.
 * @param AEND Urcuje koncovou hodnotu stupnice.
 * @param run Pokud je nastaveno na TRUE, provede okamzite prekresleni panelu.
 *
 * @since  0.2
 */
  void setRange (int Astart = 0, int Aend = 100, bool run=false);

/**
 * Nastavi pocet dilku stupnice.
 *
 * @param Count Urcuje pocet casti stupnice.
 * @param run Pokud je nastaveno na TRUE, provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setMember (int Count, bool run=false);

/**
 * Nastavi barvu analogove rucicky.
 *
 * @param fingerColor Urcuje barvu rucicky.
 * @param run Pokud je nastaveno na TRUE, provede okamzite prekresleni panelu.
 *
 * @since  0.2
 */
  void setFingerColor (QColor fingerColor, bool run=false);

/**
 * Nastavi barvu textu.
 *
 * @param fontColor Urcuje barvu rucicky.
 * @param run Pokud je nastaveno na TRUE, provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setFontColor (QColor fontColor,  bool run=false );


  
/**
 * Nastavi rozsah stupnice.
 *
 * @param finger Urcuje barvu stupnice.
 * @param run Pokud je nastaveno na TRUE, provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setScaleColor (QColor scale, bool run=false);

/**
 * Posune rucicku na hodnotu finger.
 *
 * @param finger Urcuje hodnotu na jakou bude nastavena rucicka.
 * @param run Pokud je nastaveno na TRUE, provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setFinger (float finger,  bool run=true );


/**
 * Konstanta, udava velikost analogoveho panelu v bodech.
 *
 * @since  0.1
 */
  static const int AnalogWidth = 130;


  public slots:

/**
 * Nastavi font stupnice, zmena je provedena okamzite.
 *
 * @param newScaleFont Urcuje novy font hodnot stupnice.
 *
 * @since  0.1
 */
  void slotSetScaleFont(QFont newScaleFont);


/**
 * Nastavi font textu, zmena je provedena okamzite.
 *
 * @param newTextFont Urcuje novy font pro texty.
 *
 * @since  0.1
 */
  void slotSetTextFont(QFont newTextFont);


/**
 * Nastavi font stupnice a textu, zmena je provedena okamzite.
 *
 * @param newTextFont Urcuje novy font pro texty a hodnoty stupnice.
 *
 * @since  0.1
 */
  void slotSetAllFont(QFont newAllFont);


/**
 * Da povel k prekreseni urovne pozadi a  urovne rucicky.
 * To znamena, ze bude prekreslen kompletne cely panel.
 *
 * @since  0.1
 */
  void repaintAll (void);
    
    
  protected:
  virtual void resizeEvent( QResizeEvent * );
  virtual void paintEvent( QPaintEvent * );

  private:
/**
 * @internal
 */
  void KresliCMK ( QPainter *paint );

/**
 * @internal
 */
  void KresliSt ( QPainter *paint );

/**
 * @internal
 */
  void KresliText ( QPainter *paint );

/**
 * @internal
 */
  void KresliRucicku (  QPainter *paint, float pozice);

/**
 * @internal
 */
  void KresliStupnici ( QPainter *paint );
  
  static const int PixPozadiWidth = 122;
  static const int PixPozadiStart = 4;

  bool zobrazPozadi;
  bool zobrazRucicku;

  int dolni_mez, horni_mez;
  int typ_zobrazeni;   // udava typ meraku
  int pocet_casti; // pocet policek na stupnici
  int pocet_dilku; // pocet dilku v policku na stupnici
  QColor rucicka, stupnice, barvaTextu; // barvy rucicky pozadi stupnice

  QColor barvy_arc[9];
  QString AnNadpis, AnMJ;
  int pocet_zvyrazneni; // pocet barevnych poli na stupnici
  float pozice_rucicky;
  float  uhel_zobrazeni, pocatecni_uhel;
  int stred_x, stred_y, smer, sirkaMK, vzdalenost_st;

  QFont st_font;
  QFont text_font;

  QPixmap *vrstvaPozadi;
  QPixmap *vrstvaStupnice;
  QPixmap *vrstvaRucicky;
  QPixmap *kompletVrstva;
  zvyraz zvyrazneni[5];
};


#endif
