/***************************************************************************
                          logedit.cpp  -  description
                             -------------------
    begin                : Sun Jul 23 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kstddirs.h>
#include <kmessagebox.h>
#include <kdatetbl.h>
#include <qfontmetrics.h>
#include <qdatetime.h>
#include <kglobal.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "logedit.h"
#include "logbook.h"
#include "globals.h"
#include "logsearch.h"

logEdit::logEdit(QWidget *parent, myQListViewItem* _item) : KDialogBase(parent)
{

	int i;
	item = _item;
	setWFlags (WDestructiveClose);
	setCaption (i18n("Edit QSO"));
	enableButtonSeparator (true);
	showButtonApply (false);

	upperValidator* validator = new upperValidator();
	QLabel* label;

	/* Build the main widget for the dialog with an qgrid */

	QWidget* mainWidget = new QWidget (this);
	QFontMetrics fm (mainWidget->font());

	setMainWidget (mainWidget);
	QGridLayout* grid = new QGridLayout (mainWidget);	
	grid->addRowSpacing (0, 5);

	// all col spacings

	grid->addColSpacing (0, 5);
	grid->addColSpacing (2, 5);

	callEdit = new myQLineEdit (mainWidget);
	callEdit->setValidator (validator);
	callEdit->setFixedWidth (100);
  label = new QLabel( callEdit, i18n ("&Call:"), mainWidget);
	grid->addWidget (label, 0, 1, Qt::AlignRight);
	grid->addWidget (callEdit, 0, 3, Qt::AlignLeft);
	grid->addRowSpacing (1,5);

	nameEdit = new QLineEdit (mainWidget);
  label = new QLabel( nameEdit, i18n ("&Name:"), mainWidget);
	grid->addWidget (label, 2, 1, Qt::AlignRight);
	grid->addWidget (nameEdit, 2, 3);
	grid->addRowSpacing (3, 5);

	qthEdit = new QLineEdit (mainWidget);
  label = new QLabel( qthEdit, i18n ("&QTH:"), mainWidget);
	grid->addWidget (label, 4, 1, Qt::AlignRight);
	grid->addWidget (qthEdit, 4, 3);
	grid->addRowSpacing (5, 5);

	/* Create an HBox for the 2 RST items */

	QHBoxLayout* hbox = new QHBoxLayout ();
	grid->addMultiCellLayout (hbox, 6, 6, 2, 3);
	hbox->setSpacing (5);

	rstsEdit = new QLineEdit (mainWidget);
	rstsEdit->setFixedWidth (fm.width("MMMMM"));
  label = new QLabel( rstsEdit, i18n ("RST &Sended:"), mainWidget);
	grid->addWidget (label, 6,1, Qt::AlignRight);
	hbox->addSpacing (5);
	hbox->addWidget (rstsEdit);
	hbox->addStretch (1);

	rstrEdit = new QLineEdit (mainWidget);
	rstrEdit->setFixedWidth (fm.width("MMMMM"));
  label = new QLabel( rstrEdit, i18n ("RST &Received:"), mainWidget);
	hbox->addWidget (label);
	hbox->addWidget (rstrEdit);
	grid->addRowSpacing (7,5);

	bandEdit = new QComboBox (mainWidget);
	for (i=0;i<12;++i)
		bandEdit->insertItem (config.band.band[i], i);
	bandEdit->setFixedWidth(75);
  label = new QLabel( bandEdit, i18n ("&Band:"), mainWidget);
	grid->addWidget (label, 8, 1, Qt::AlignRight);
	grid->addWidget (bandEdit, 8, 3, Qt::AlignLeft);
	grid->addRowSpacing (9, 5);

	notesEdit = new QLineEdit (mainWidget);
  label = new QLabel( notesEdit, i18n ("&Notes:"), mainWidget);
	grid->addWidget (label, 10, 1, Qt::AlignRight);
	grid->addWidget (notesEdit, 10, 3);
	grid->addRowSpacing (11, 5);


	/* Set the Text to the fields */

	callEdit->setText (item->text (LIST_CALL));
	nameEdit->setText (item->text (LIST_NAME));
	notesEdit->setText (item->text (LIST_NOTES));
	rstsEdit->setText (item->text (LIST_RSTS));
	rstrEdit->setText (item->text (LIST_RSTR));
	qthEdit->setText (item->text (LIST_QTH));
	for (i=0;i<bandEdit->count();++i) {
    if (item->text (LIST_BAND) == bandEdit->text(i)) {
			bandEdit->setCurrentItem (i);
			break;
		}
	}
}

logEdit::~logEdit()
{
}

void logEdit::slotOk()
{
	/* replace - that meens removing and inserting! */
	logdb->removeQSO(item->index());
	logdb->appendQSO(callEdit->text(), nameEdit->text(), qthEdit->text(), rstrEdit->text(),
	rstsEdit->text(), bandEdit->currentText(), notesEdit->text(), item->index());

	item->setText (LIST_CALL, callEdit->text());
	item->setText (LIST_NAME, nameEdit->text());
	item->setText (LIST_NOTES, notesEdit->text());
	item->setText (LIST_RSTS, rstsEdit->text());
	item->setText (LIST_RSTR, rstrEdit->text());
	item->setText (LIST_QTH, qthEdit->text());
	item->setText (LIST_BAND, bandEdit->currentText());
	KDialogBase::slotOk();
}
