#ifndef _KVI_TREELISTDIALOG_QT_H_INCLUDED_
#define _KVI_TREELISTDIALOG_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_treelistdialog_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qpixmap.h>
#include <qptrdict.h>
#include <qwidget.h>

class QVBox;
class QWidgetStack;

class KviLabel;
class KviListView;
class KviListViewItem;

class KviTreeListDialog : public QWidget
{
	Q_OBJECT
public:
	KviTreeListDialog(
		QWidget *parent = 0, const char *name = 0, bool modal = true,
		const QString &caption = QString::null, int buttonMask = 0
	);

	~KviTreeListDialog();

	void delayedDestruct();
	void setButtonHelpText(const QString & /* ignored */);

	QVBox *addVBoxPage(const QStringList &items, const QString &header = QString::null, const QPixmap &pixmap = QPixmap());
signals:
	void finished();
	void aboutToShowPage(QWidget *);

	void cancelClicked();
	void helpClicked();
	void okClicked();
protected slots:
	void listViewItemSelectionChanged(KviListViewItem *);
private:
	KviListView       *m_pListView;
	QWidgetStack      *m_pWidgetStack;
	QPtrDict<QWidget>  m_pPages;

	KviListViewItem *findTopLevelItem(const QString &name);
};

#endif // _KVI_TREELISTDIALOG_QT_H_INCLUDED_
