/***************************************************************************
                          kxeelementdialog.h  -  description
                          ------------------
    begin                : Mit Apr 17 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXEELEMENTDIALOG_H
#define KXEELEMENTDIALOG_H

#include "kxeelementdialogbase.h"

class KXEElementDialog : public KXEElementDialogBase
{
		Q_OBJECT

	public:
		KXEElementDialog( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

	public:

    const QString nsURI() const { return m_strNsURI; }
    const QString prefix() const { return m_strPrefix; }
    const QString name() const { return m_strName; }
    const bool atTop() const { return m_bAtTop; }

    void setNsURI(const QString strNsURI) { m_strNsURI = strNsURI; }
    void setPrefix(const QString strPrefix) { m_strPrefix = strPrefix; }
    void setName(const QString strName)  { m_strName = strName; }
  
		/**
		 * To be used for creating a new XML element 
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( bool, bool, bool );

    // check element name
    static QString checkName(const QString);
		
	protected:
    /**
		 * Clears the dialogs widgets (removes their content).
		 */
     
		void clearDialog();

    /**
		 * Fills the dialogs widgets with the data members.
		 */
		void fillDialog( bool );

		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref DlgXMLElement::exec functions instead.
		 */
		int exec();
		/**
		 * Called, when the namespace URI in the edit line @ref DlgXMLElementBase::m_pEditNsURI
		 * is changed.
		 * Disables the prefix edit line (@ref DlgXMLElementBase::m_pEditPrefix),
		 * if the given string is empty.
		 */
  

 protected slots:
		void slotNsURIChanged( const QString & szNewNsURI );
		/**
		 * Called, when the name in the edit line @ref DlgXMLElementBase::m_pEditName
		 * is changed.
		 * Disables the OK button, if the given string is empty.
		 */
		void slotNameChanged( const QString & szNewName );

protected:
    QString m_strNsURI;
    QString m_strPrefix;
    QString m_strName;
    bool m_bAtTop;
};

#endif
