/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_PROTOCOL_H__
#define __LADCCA_PROTOCOL_H__

#include <stdint.h>

typedef uint32_t cca_protocol_t;

#define CCA_PROTOCOL_MAJOR 2
#define CCA_PROTOCOL_MINOR 0

/*
 * Protocol versions (release: protocol):
 *
 * 0.3: 1.1
 * 0.2: 1.0
 * 0.1: 0.0 (implied by the 0ing of the cca_event_t.event_data)
 */

#define CCA_PROTOCOL_MAJOR_MASK 0xFFFF0000
#define CCA_PROTOCOL_MINOR_MASK 0x0000FFFF

#define CCA_PROTOCOL(major, minor) \
  ((cca_protocol_t)( ((major << 16) & CCA_PROTOCOL_MAJOR_MASK) | \
                     (minor & CCA_PROTOCOL_MINOR_MASK)             ))

#define CCA_PROTOCOL_VERSION (CCA_PROTOCOL (CCA_PROTOCOL_MAJOR, CCA_PROTOCOL_MINOR))

#define CCA_PROTOCOL_GET_MAJOR(protocol)  ((cca_protocol_t) (((protocol & CCA_PROTOCOL_MAJOR_MASK) >> 16)))
#define CCA_PROTOCOL_GET_MINOR(protocol)  ((cca_protocol_t) (protocol & CCA_PROTOCOL_MINOR_MASK))

#define CCA_PROTOCOL_IS_VALID(proto) \
  ((CCA_PROTOCOL_GET_MAJOR (proto) == CCA_PROTOCOL_MAJOR) && \
   (CCA_PROTOCOL_GET_MINOR (proto) <= CCA_PROTOCOL_MINOR))

const char * cca_protocol_string (cca_protocol_t protocol);

#endif /* __LADCCA_PROTOCOL_H__ */
