/*
 *   LADCCA
 *    
 *   Copyright (C) 2003 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ladcca/ladcca.h>
#include <ladcca/internal_headers.h>

cca_connect_params_t *
cca_connect_params_new ()
{
  cca_connect_params_t *params;

  params = cca_malloc0 (sizeof (cca_connect_params_t));

  uuid_clear (params->id);

  return params;
}

void                   cca_connect_params_destroy (cca_connect_params_t *params)
{
  set_string_property (params->project, NULL);
  set_string_property (params->working_dir, NULL);
  set_string_property (params->class, NULL);
}

void
cca_connect_params_set_project (cca_connect_params_t *params, const char *project)
{
  set_string_property (params->project, project);
}

void
cca_connect_params_set_working_dir (cca_connect_params_t *params, const char *working_dir)
{
  set_string_property (params->working_dir, working_dir);
}

void
cca_connect_params_set_class (cca_connect_params_t *params, const char *class)
{
  set_string_property (params->class, class);
}
