//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


// Definition of the reply class


#ifndef _xmlrpc_reply_class_
#define _xmlrpc_reply_class_


#include <string>
#include <vector>

#include "xml.hpp"

namespace xmlrpc
{
  class reply : public xml::persistable
  {
  public:

    reply ( const std::string value = "" );
    virtual ~reply();

    //
    // Methods you are interested in
    //
    std::string set_value ( const std::string s ) { m_value = s; }
    std::string get_value() const { return m_value; }

    void add_error ( const std::string s ) { m_errors.push_back ( s ); }
    std::string get_error ( const int ) const;
    long get_error_count() const { return m_errors.size(); }


    //
    // Methods used internally by
    // the framework
    //
    virtual std::string get_xml() const;
    virtual void load_xml ( const std::string );
    std::string terminator() const { return "abcdef_reply_end_abcdef"; }

  private:

    std::vector<std::string> m_errors;
    std::string m_value;
  };
};

#endif
