/*  Copyright (C) 2003 Cherry George Mathew <cherry@freeshell.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <linux/init.h> 
#include <linux/pci.h>
#include <linux/i2c.h>
#include <linux/i2c-algo-bit.h>
#include <linux/videodev.h>
/* We'll upgrade to V4L2, once we're 
 * up and include.
 */
#include <linux/spinlock.h>   /* Just for extra safety. We're writing into \
				 reserved vga io space. Don't want any funny\
				 stuff there. */
/* Functional level debugging */
#define dprintk(fmt, args...) if (debug>=1) printk(KERN_DEBUG "pvcl-debug: " fmt, ## args);
/* Debugging single functions */
#define tprintk(fmt, args...) if (debug>=2) printk(KERN_DEBUG "pvcl-debug: " fmt, ## args);
/* Warning - too verbose. Debugging port conversations. */
#define vprintk(fmt, args...) if (debug>=3) printk(KERN_DEBUG "pvcl-debug:" fmt, ## args);

#define MAX_CARDS 2

#define GD_SR_OFFSET 0x3c4
#define GD_GR_OFFSET 0x3ce
#define GD_CR_OFFSET 0x3d4

#define GD_CHROMA_KEY 0x80

struct gd_status_t
{
	struct video_buffer * vbuf_p;
        struct video_window * vwin_p;
	struct video_tuner  * vtun_p;
	struct video_channel *vchan_p;
        struct video_picture *vpict_p;
	struct i2c_adapter  * adapter_p;
	unsigned long freq;
};

/* Card structure below holds info about the adapter card on which the \
 * I2C bus sits on.
 */


struct clgd54xx_card{
        unsigned short clgd54xx_pci_dev_id;	
        int vram;
	int model;
        unsigned long gd_io_base;
	struct pci_dev *clgd54xx_pci_dev_p;
	long spinflags;
	spinlock_t spun_lock;
	unsigned long i2c_state;
	struct i2c_adapter *clgd54xx_adapter_p;
        struct i2c_algo_bit_data *clgd54xx_bitbang_adapter_p;
        struct gd_status_t * drv_stat_p;
};

/* Function Definitions. */
/* Register level functions. */

static inline unsigned io_readb (unsigned);
static inline void io_writeb (unsigned, unsigned);

static inline void gd_write_sr(struct clgd54xx_card *, unsigned char ,unsigned );
static inline void gd_write_gr(struct clgd54xx_card *, unsigned char ,unsigned );
static inline void gd_write_cr(struct clgd54xx_card *, unsigned char ,unsigned );

static inline unsigned gd_read_sr(struct clgd54xx_card *, unsigned );
static inline unsigned gd_read_gr(struct clgd54xx_card *, unsigned reg);
static inline unsigned gd_read_cr(struct clgd54xx_card *, unsigned reg);


/* VGA Wrapper functions */
static void gd_bit_copy(unsigned long * dest, int dest_start,
			unsigned long * src, int src_start, int src_stop);
static long gd_window_init(struct clgd54xx_card *);

/* VGA hardware video programming functions. */

static void gd_enable_window(struct clgd54xx_card *);
static void gd_disable_window(struct clgd54xx_card *);
static void gd_set_vbuf1(struct clgd54xx_card *, unsigned long );
static void gd_set_vbuf2(struct clgd54xx_card *, unsigned long );
static unsigned long gd_get_vbuf1(struct clgd54xx_card *);
static unsigned long gd_get_vbuf2(struct clgd54xx_card *);
static void gd_set_pitch(struct clgd54xx_card * card_p, unsigned long ); 
static unsigned long gd_get_pitch(struct clgd54xx_card *);

/* VGA video window functions */
static void gd_set_window(struct clgd54xx_card *,
			  struct video_window *, 
			  struct video_window *,
			  struct video_buffer *);
static void gd_get_window(struct clgd54xx_card *,
			  struct video_window *, struct video_buffer *);

/* I2C bus bit level functions. */
static void gd54xx_setsda (void *bit_adap_dat, int state); 
static void gd54xx_setscl (void *bit_adap_dat, int state); 
static int gd54xx_getsda (void *bit_adap_dat);
static int gd54xx_getscl (void *bit_adap_dat);

/* I2C callbacks. */
static int i2c_clgd54xx_init_adapter(struct clgd54xx_card *,
				     struct i2c_adapter *,
				     struct i2c_algo_bit_data *);
static int i2c_clgd54xx_cleanup_adapter(struct clgd54xx_card *);
static int i2c_clgd54xx_probe_card(struct clgd54xx_card *);
static int i2c_clgd54xx_find_card(struct clgd54xx_card *);
static int __init i2c_clgd54xx_init(struct clgd54xx_card *,
				    struct i2c_adapter *,
				    struct i2c_algo_bit_data *);
static int __init i2c_clgd54xx_cleanup(struct clgd54xx_card *);

/* Generic VGA Routines */

static int gd_count_ram(struct clgd54xx_card *card_p);

/* V4L Callbacks */
static void do_client_ioctl(struct file*, unsigned int cmd, void *arg);

