/***************************************************************************
                          xosdctrl.cpp  -  description
                             -------------------
    begin                : Sat Feb 22 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <lineak/lconfig.h>
#include <lineak/lineak_core_functions.h>
using namespace lineak_core_functions;
#include "xosdctrl.h"
//#include "lineak_core_functions.h"
//float xosdCtrl::MaxAudio = 25700.00;
//const float xosdCtrl::MUTE = -100.0000;

xosdCtrl::xosdCtrl(LConfig& config) : displayCtrl(config) {
  ScrollAge = true;
  create(2);
  setFont(config["Display_font"]);
  setColor(config["Display_color"]);

  string position = config["Display_pos"];
     if (position == "top")
       setPos((xosd_pos)XOSD_top);
     if (position == "middle")
       setPos((xosd_pos)XOSD_middle);
     if (position == "bottom" || position == "")
       setPos((xosd_pos)XOSD_bottom);
  string align = config["Display_align"];
     if (align == "left")
       setAlign((xosd_align)XOSD_left);
     if (align == "center" || align == "")
       setAlign((xosd_align)XOSD_center);
     if (align == "right")
       setAlign((xosd_align)XOSD_right);

  setTimeout(atoi(config.getValue("Display_timeout").c_str()));
//  setPos((xosd_pos)config.getIntValue("XOSD_pos"));
//  setAlign((xosd_align)config.getIntValue("XOSD_align"));
  setHorizontalOffset(atoi(config.getValue("Display_hoffset").c_str()));
  setVerticalOffset(atoi(config.getValue("Display_voffset").c_str()));
  setShadowOffset(atoi(config.getValue("Display_soffset").c_str()));

  //config.print(cout);
  msg("Our parameters!");
  msg(config["Display_font"]);
  msg(config["Display_color"]);
  msg(config["Display_pos"]);
  msg(config["Display_align"]);
  msg(config.getValue("Display_timeout"));
  msg(config.getValue("Display_hoffset"));
  msg(config.getValue("Display_voffset"));
  msg(config.getValue("Display_soffset"));
  
  Forcewait=false;
  ScreenLine = 0;
  /* Not really needed, but at least we aren't throwing around an unknown value */
  old_age.tv_sec=0;

  if (ScrollAge)
    gettimeofday(&old_age,0);
}

xosdCtrl::xosdCtrl(string font, string color, int delay, xosd_pos pos, xosd_align align, int hoffset, int voffset, int soffset, int lines) {
  ScrollAge = true;
  create(lines);
  setFont(font);
  setColor(color);
  setTimeout(delay);
  setPos(pos);
  setAlign(align);
  setHorizontalOffset(hoffset);
  setVerticalOffset(voffset);
  setShadowOffset(soffset);
  Forcewait=false;
  ScreenLine = 0;
  /* Not really needed, but at least we aren't throwing around an unknown value */
  old_age.tv_sec=0;

  if (ScrollAge)
  	gettimeofday(&old_age,0);
}

xosdCtrl::xosdCtrl() : displayCtrl() {
/* Set my defaults */
  ScrollAge = true;
  create(2);
  setFont(DISPLAY_FONT);
  setColor(DISPLAY_COLOR);
  setTimeout(atoi(DISPLAY_TIMEOUT));
  setPos(XOSD_bottom);
  setAlign(XOSD_center);
  setHorizontalOffset(atoi(DISPLAY_HOFFSET));
  setVerticalOffset(atoi(DISPLAY_VOFFSET));
  setShadowOffset(atoi(DISPLAY_SOFFSET));
  Forcewait=false;
  ScreenLine = 0;
  /* Not really needed, but at least we aren't throwing around an unknown value */
  old_age.tv_sec=0;

  if (ScrollAge)
    gettimeofday(&old_age,0);

}
xosdCtrl::~xosdCtrl(){
}
void xosdCtrl::create(int lines) {
	Lines=lines;
	osd = xosd_create(Lines);
    /** This can happen in the situations where LANG is an asian character set */
    if (!osd) {
      cerr << "Error initializing osd: " << xosd_error << endl;
//      // Attempt to instantiate an X manager object. If we cannot connect to X, then it will
//      Xmgr tmpX;
//      if (!tmpX.getDisplay()) {
//        cerr << "Could not get the display" << endl;
//
//      }
    }
   /* Not really needed, but at least we aren't throwing around an unknown value */
    old_age.tv_sec=0;

    if (ScrollAge)
    	gettimeofday(&old_age,0);
}
void xosdCtrl::init(LConfig& config){
   create(Lines);

   setFont(config["Display_font"]);
   setColor(config["Display_color"]);

   string position = config["Display_pos"];
   if (position == "top")
      setPos((xosd_pos)XOSD_top);
   if (position == "middle")
      setPos((xosd_pos)XOSD_middle);
   if (position == "bottom" || position == "")
      setPos((xosd_pos)XOSD_bottom);
   string align = config["Display_align"];
   if (align == "left")
      setAlign((xosd_align)XOSD_left);
   if (align == "center" || align == "")
      setAlign((xosd_align)XOSD_center);
   if (align == "right")
      setAlign((xosd_align)XOSD_right);

   setTimeout(atoi(config.getValue("Display_timeout").c_str()));
   //  setPos((xosd_pos)config.getIntValue("XOSD_pos"));
   //  setAlign((xosd_align)config.getIntValue("XOSD_align"));
   setHorizontalOffset(atoi(config.getValue("Display_hoffset").c_str()));
   setVerticalOffset(atoi(config.getValue("Display_voffset").c_str()));
   setShadowOffset(atoi(config.getValue("Display_soffset").c_str()));

   /* Not really needed, but at least we aren't throwing around an unknown value */
    old_age.tv_sec=0;

    if (ScrollAge)
    	gettimeofday(&old_age,0);

}
void xosdCtrl::init(){
/* Set my defaults */
    create(Lines);
    setFont(Font);
    setColor(Color);
    setTimeout(Timeout);
    setPos(Pos);
    setAlign(Align);
    setHorizontalOffset(HorizontalOffset);
    setVerticalOffset(VerticalOffset);
    setShadowOffset(ShadowOffset);
   /* Not really needed, but at least we aren't throwing around an unknown value */
    old_age.tv_sec=0;

    if (ScrollAge)
    	gettimeofday(&old_age,0);
}

void xosdCtrl::cleanup() {
   scroll();
   msg("xosdCtrl::cleanup() -- Cleaning up xosd");
   if (osd != NULL) {
        msg("xosdCtrl::cleanup() -- xosd_destroy");
        /** For some reason, xosd_destroy hangs sometimes. */
  	xosd_destroy (osd);
    	osd = NULL;
    }
    msg("xosdCtrl::cleanup() -- done cleanup");
}

void xosdCtrl::agenscroll(void) {
  /* Should we age the display? */
  if (ScrollAge)
  {
     gettimeofday(&new_age,0);
     if ((new_age.tv_sec - old_age.tv_sec) > ScrollAge)
     {
        scroll();
        ScreenLine=0;
     }
  }

  if (osd) {
  	if (ScreenLine >= xosd_get_number_lines(osd))
  	{
     		scroll(1);
     		ScreenLine = xosd_get_number_lines(osd)-1;
  	}
  		if (Forcewait && xosd_is_onscreen(osd)) {
     		xosd_wait_until_no_display(osd);
  	}
  }
}

void xosdCtrl::age(void) {
  old_age.tv_sec = new_age.tv_sec;
}

/* Modify the volume display output */
void xosdCtrl::volume(float ivolume) {
  float volcalc;
  scroll();
     if (ivolume == MUTE) {
        if (osd)
           xosd_display (osd, ScreenLine++, XOSD_string, "Volume Muted");
				//agenscroll();
     }
     else {
		volcalc = (float)ivolume;
		volcalc /= MaxAudio;
		volcalc *= 100.00;
		int volume = (int) volcalc;
		if (osd) {
			xosd_display (osd, 0, XOSD_string, "Volume");
			xosd_display (osd, 1, XOSD_percentage, volume);
		}
     }

}
/* Display an onscreen command */
void xosdCtrl::show(string command) {
	if (osd) {
		scroll();
	  	xosd_display (osd, ScreenLine++, XOSD_string, command.c_str());
	}
}

/** Read property of string font. */
const string& xosdCtrl::getFont(){
	return Font;
}
/** Write property of string font. */
void xosdCtrl::setFont( const string& _newVal){
	Font = _newVal;
	if (osd) {
		//char *font =  (char *)malloc((strlen(Font.c_str())+1)*sizeof(char));
		//strcpy(font, Font.c_str());
		//if (xosd_set_font (osd, font) == -1)
		// If you cannot set the font, fall back to the default.
		if (xosd_set_font (osd, Font.c_str()) == -1) {
		   error("xosd_set_font: has failed");
		   Font = DISPLAY_FONT;
		   xosd_set_font (osd, DISPLAY_FONT);
		}
		if (!osd) {
		   error("osd has failed to initialize and is now invalid.");
		   osd = NULL;
		}
		//free(font);
	}
}
/** Read property of string color. */
const string& xosdCtrl::getColor(){
	return Color;
}
/** Write property of string color. */
void xosdCtrl::setColor( const string& _newVal){
	Color = _newVal;
	if (osd) {
		string tmp = '#' + Color;
		char *color =  (char *)malloc((strlen(tmp.c_str())+1)*sizeof(char));
		strcpy(color, tmp.c_str());
		xosd_set_colour (osd, color);
		free(color);
	}
}
/** Read property of int delay. */
const int& xosdCtrl::getTimeout(){
	return Timeout;
}
/** Write property of int delay. */
void xosdCtrl::setTimeout( const int& _newVal){
	Timeout = _newVal;
	if (osd)
		xosd_set_timeout (osd, Timeout);
}
/** Read property of int Forcewait. */
const bool& xosdCtrl::getForcewait(){
	return Forcewait;
}
/** Write property of int Forcewait. */
void xosdCtrl::setForcewait( const bool& _newVal){
	Forcewait = _newVal;
}
/** Read property of xosd_pos Pos. */
const xosd_pos& xosdCtrl::getPos(){
	return Pos;
}
/** Write property of xosd_pos Pos. */
void xosdCtrl::setPos( const xosd_pos& _newVal){
	Pos = _newVal;
	if (osd)
		xosd_set_pos (osd, Pos);
}
/** Read property of int Offset. */
const int& xosdCtrl::getHorizontalOffset(){
	return HorizontalOffset;
}
/** Write property of int Offset. */
void xosdCtrl::setHorizontalOffset( const int& _newVal){
	HorizontalOffset = _newVal;
	if (osd)
		xosd_set_horizontal_offset (osd, HorizontalOffset);
}
/** Read property of int Offset. */
const int& xosdCtrl::getVerticalOffset(){
	return VerticalOffset;
}
/** Write property of int Offset. */
void xosdCtrl::setVerticalOffset( const int& _newVal){
	VerticalOffset = _newVal;
	if (osd)
		xosd_set_vertical_offset (osd, VerticalOffset);
}
/** Read property of int Shadow. */
const int& xosdCtrl::getShadowOffset(){
	return ShadowOffset;
}
/** Write property of int Shadow. */
void xosdCtrl::setShadowOffset( const int& _newVal){
	ShadowOffset = _newVal;
	if (osd)
		xosd_set_shadow_offset (osd, ShadowOffset);
}
/** Read property of int ScrollAge. */
const bool& xosdCtrl::getScrollAge(){
	return ScrollAge;
}
/** Write property of int ScrollAge. */
void xosdCtrl::setScrollAge( const bool& _newVal){
	ScrollAge = _newVal;

    if (ScrollAge)
      gettimeofday(&old_age,0);  
}
/** Read property of int ScreenLine. */
const int& xosdCtrl::getScreenLine(){
	return ScreenLine;
}
/** Write property of int ScreenLine. */
void xosdCtrl::setScreenLine( const int& _newVal){
	ScreenLine = _newVal;
}
/** Read property of int Lines. */
const int& xosdCtrl::getLines(){
	return Lines;
}
/** Write property of int Lines. */
void xosdCtrl::setLines( const int& _newVal){
	Lines = _newVal;
}
const xosd_align& xosdCtrl::getAlign(){
	return Align;
}
/** Write property of xosd_align Align. */
void xosdCtrl::setAlign( const xosd_align& _newVal){
	Align = _newVal;
	if (osd)
		xosd_set_align (osd, Align);
}
void xosdCtrl::show() {
	if (osd)
		xosd_show (osd);
}
void xosdCtrl::hide() {
	if (osd) 
		xosd_hide (osd);
}
/** Read property of xosd_align Align. */
/** Scroll the display lines number of lines */
void xosdCtrl::scroll(int lines){
	if (osd) {
		if (lines != 0)
			xosd_scroll(osd,lines);
		else
			xosd_scroll(osd,xosd_get_number_lines(osd));
	}
}
