#ifndef _LCS_CMD_LCP3_H
#define _LCS_CMD_LCP3_H

#include "client.h"
#include "lists.h"
#include "global_vars.h"
#include <time.h>

/* packet queue */
struct t_lcp3_ordq_item {
    struct list_hdr_t *prev;
    struct list_hdr_t *next;
    struct client_t *who;
    // end of list_hdr_t compatible header
    struct line_t *specline; // don't take the line selected by the client
	// to generate the info, take specline instead (if not NULL).
    int cmd;
    char cnt;
//    time_t first_send;
    time_t prev_send;
    int infosize;
    char info[LCP3_MAX_INFO_SIZE];
};
extern struct list_anchor_t lcp3_ordq;

/* init */
int lcp3_init();

/* manipulating */
void lcp3_ordq_check(); // checks the lcp3_ordq for timeouts
void lcp3_ordq_checksend(struct client_t *who);

/* outgoing */
int lcp3_cmd_broadcast(int cmd, void* info, int infosize, struct line_t *line);
int lcp3_cmd_direct(int cmd, int tcp_socket, void* info, int infosize);
int lcp3_cmd_queue(int cmd, struct client_t *who, void* info, int infosize);
int lcp3_cmd_send(struct t_lcp3_ordq_item *item);
int lcp3_ack_send(int cmd, struct client_t *who);

/* incoming */
int lcp3_proc_ack(int cmd, struct client_t *who);

#endif
