/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Thread.h"
#include "Exception.h"

#include <wx/debug.h>
#include <wx/log.h>

CThread::CThread() :
wxThread(),
m_stopped(false)
{
}

CThread::~CThread()
{
}

void* CThread::Entry()
{
	::wxLogInfo(wxT("%ld: Starting restartable Thread"), GetId());

	// Wait for the Pause() to be issued
	Sleep(2000);

	while (!TestDestroy()) {
		try {
			run();
		}
		catch (CException& e) {
			error(e.getMessage().c_str());
		}
		catch (...) {
			error(wxT("An exception occured in Thread"));
		}

		m_stopped = false;
	}

	::wxLogInfo(wxT("%ld: Ending restartable Thread"), GetId());

	return NULL;
}

void CThread::stop()
{
	m_stopped = true;
}

bool CThread::isStopped() const
{
	return m_stopped;
}
