/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Defs_H
#define	FSK441Defs_H

const int FSK441_SAMPLE_RATE    = 11025;
const int FSK441_SYMBOL_LENGTH  = 25;
const int FSK441_FFT_LENGTH     = FSK441_SYMBOL_LENGTH;
const int FSK441_CHAR_LENGTH    = 3;

const int FSK441_MAX_AUDIO_DATA = 30 * FSK441_SAMPLE_RATE;

const int FSK441_BIN0 = 2;
const int FSK441_BIN1 = 3;
const int FSK441_BIN2 = 4;
const int FSK441_BIN3 = 5;

const double FSK441_SEND_VOLUME = 0.5;

const double FSK441_MIN_CORRVAL = 0.27;

const int FSK441_MAX_MESSAGE_LENGTH = 30;

const int FSK441_SOUNDBUF_LENGTH = 2048;

// For the GUI
const wxString FSK441_LOGFILE_NAME  = wxT("fsk441.log");
const wxString FSK441_MESSAGES_NAME = wxT("fsk441.cum");

const wxString title = wxT("FSK441 for Linux 0.4.7 (LinWSJT)");

const int FSK441_MAX_MESSAGES   = 6;

const int FSK441_LEVEL_WIDTH     = 470;
const int FSK441_SPECTRUM_WIDTH  = 125;
const int FSK441_GRAPH_HEIGHT    = 125;
const int FSK441_MESSAGES_WIDTH  = 600;
const int FSK441_MESSAGES_HEIGHT = 150;

const int FSK441_NUM_COLOURS     = 16;

// For the configuration
const wxString FSK441_VENDOR_NAME = wxT("G4KLX");
const wxString FSK441_APPL_NAME   = wxT("FSK441");

const wxString SECTION_GENERAL  = wxT("General");
const wxString SECTION_TRANSMIT = wxT("Transmit");
const wxString SECTION_RECEIVE  = wxT("Receive");
const wxString SECTION_SOUND    = wxT("Sound");
const wxString SECTION_PTT      = wxT("PTT");
const wxString SECTION_PROTOCOL = wxT("Protocol");
const wxString SECTION_MESSAGES = wxT("Messages");

const wxString KEY_CALLSIGN     = wxT("callsign");
const wxString KEY_LOCATOR      = wxT("locator");
const wxString KEY_FIRST        = wxT("first");
const wxString KEY_MIN_LENGTH   = wxT("min_length");
const wxString KEY_MIN_STRENGTH = wxT("min_strength");
const wxString KEY_TYPE         = wxT("type");
const wxString KEY_FILENAME     = wxT("filename");
const wxString KEY_BITS         = wxT("bits");
const wxString KEY_DEVICE       = wxT("device");
const wxString KEY_SINGLE_TONE  = wxT("single_tone_receive");
const wxString KEY_MESSAGE      = wxT("message_");

const wxString DEFAULT_CALLSIGN = wxT("G4KLX");
const wxString DEFAULT_LOCATOR  = wxT("IO93FB");

const bool DEFAULT_TX_ENABLED = false;
const bool DEFAULT_TX_FIRST   = true;

const int DEFAULT_MIN_LENGTH   = 40;
const int DEFAULT_MIN_STRENGTH = 3;

const wxString DEFAULT_PTT_TYPE   = wxT("none");
const wxString DEFAULT_PTT_DEVICE = wxT("/dev/null");

const wxString DEFAULT_SOUND_TYPE     = wxT("card");
const wxString DEFAULT_SOUND_FILENAME = wxT("/dev/dsp");
const long     DEFAULT_SOUND_BITS     = 16L;

const bool     DEFAULT_SINGLE_TONE    = false;

const wxString DEFAULT_MESSAGE_0 = wxT("%T %M ");
const wxString DEFAULT_MESSAGE_1 = wxT("%T %M %R %R ");
const wxString DEFAULT_MESSAGE_2 = wxT("%T %M R%R R%R ");
const wxString DEFAULT_MESSAGE_3 = wxT("%T %M RRR ");
const wxString DEFAULT_MESSAGE_4 = wxT("73 ");
const wxString DEFAULT_MESSAGE_5 = wxT("CQ %M ");

#endif
