/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44AverageMessage_H
#define	JT44AverageMessage_H

#include "JT44MessageBase.h"
#include "JT44Message.h"

#include <wx/wx.h>

class CJT44AverageMessage : public CJT44MessageBase {

    public:
	CJT44AverageMessage();
	virtual ~CJT44AverageMessage();

	virtual void     clear();

	virtual void     setId(const wxString& id);
	virtual wxString getId() const;

	virtual int      getCount() const;

	virtual void     addMessage(const CJT44Message& message);
	virtual void     subtractMessage(const CJT44Message& message);

    private:
	wxString m_id;
	int      m_count;
	wxMutex  m_mutex;
};

#endif
