/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MLevelEvent.h"

CJT6MLevelEvent::CJT6MLevelEvent(CJT6MLevels* levels, wxEventType type, int id) :
wxEvent(id, type),
m_levels(levels)
{
}

CJT6MLevelEvent::CJT6MLevelEvent(const CJT6MLevelEvent& event) :
wxEvent(event),
m_levels(event.m_levels)
{
}

CJT6MLevelEvent::~CJT6MLevelEvent()
{
}

CJT6MLevels* CJT6MLevelEvent::getLevels() const
{
	return m_levels;
}

wxEvent* CJT6MLevelEvent::Clone() const
{
	return new CJT6MLevelEvent(*this);
}
