#!/usr/bin/perl
# This script configures dictionaries-common (sarge version > 0.20)
use strict;
use warnings;

require '/usr/lib/localization-config/common/log.pl';

my %lang_locale_map = (
    # entries sorted alphabetically
    'bs_BA.ISO8859-2' => 'Bosnian',
    'bg_BG'           => 'Bulgarian',
    'ca_ES@euro'      => 'Catalan',
    'cs_CZ'           => 'Czech',
    'da_DK'           => 'Danish',
    'de_BE@euro'      => 'German (BE)',
    'de_CH'           => 'Swiss (DE)',
    'de_DE@euro'      => 'German (DE)',
    'el_GR.UTF-8'     => 'Greek',
    'en_AU'           => 'Australian',
    'en_CA'           => 'Canadian',
    'en_IE@euro'      => 'Irish (UK)',
    'ga_IE@euro'      => 'Irish',
    'gl_ES@euro'      => 'Galician',
    'en_GB'           => 'British',
    'gd_GB'           => 'Scots Gaelic',
    'gv_GB'           => 'Manx Gaelic',
    'kw_GB'           => 'Cornish',
    'en_US'           => 'American (US)',
    'es'              => 'Spanish',
    'es_AR'           => 'Spanish (AR)',
    'es_ES@euro'      => 'Spanish (ES)',
    'es_MX'           => 'Spanish (MX)',
    'es_PE'           => 'Spanish (PE)',
    'fa_IR.UTF-8'     => 'Faroe',
    'fi_FI@euro'      => 'Finnish',
    'fr_BE'           => 'Belgian',
    'fr_CA'           => 'French (CA)',
    'fr_CH'           => 'Swiss (FR)',
    'fr_FR@euro'      => 'French',
    'he_IL'           => 'Hebrew',
    'hu_HU'           => 'Hungarian',
    'it_IT@euro'      => 'Italian',
    'ja_JP.EUC-JP'    => 'Japanese',
    'ko_KR'           => 'Korean',
    'lv_LV'           => 'Latvian',
    'lt_LT'           => 'Lithuanian',
    'mk_MK'           => 'Macedonian',
    'nb_NO'           => 'Norwegian',
    'nds_DE@euro'     => 'German (ndk)',
    'nl_BE@euro'      => 'Belgian',
    'nl_NL@euro'      => 'Dutch',
    'nn_NO'           => 'New Norwegian',
    'no_NO'           => 'Norwegian',
    'pa_IN'           => 'Punjabi (Gumurkhi)',
    'pl_PL'           => 'Polish',
    'pt_PT'           => 'Portuguese',
    'pt_BR'           => 'Brazilian',
    'ru_RU'           => 'Russian',
    'se_NO'           => 'Saami',
    'sk_SK'           => 'Slovakian',
    'sl_SI'           => 'Slovenian',
    'sv_SE'           => 'Swedish',
    'sv_FI'           => 'Swedish (FI)',
    'tr_TR'           => 'Turkish',
    'tl_PH'           => 'Tagalog',
    'uk_UA'           => 'Ukrainian',
) ;

sub get_lang_map() {
    return %lang_locale_map;
}

# This is a bit complicated. If the locale passed as an argument is not on 
# the %locale_lang_map, then the script will try to do its best to guess 
# what's the closest locale in the map.
# First it will strip the the @euro part, then the encoding, the country and
# if even that fails, only the language letters will remain, and it will do 
# a search in the map for all the locales that match the language (convenient
# for weird combinations). It will then take the first entry there (hm, 
# something screams for a priority list here, but later).

sub choose_language {
    my $stage = 1;
    my ($lng, $locale_lang_map) = @_;
    while ($stage > 0) {
        if (defined($locale_lang_map->{$lng})) {
            log_msg("$0:choose_language(): Found $lng =>\t".$locale_lang_map->{$lng});
            
            return $locale_lang_map->{$lng};
        } else {
            if ($stage == 1) {
                my @keys = grep /^$lng.*$/, keys %$locale_lang_map;
                if (defined($keys[0])) {
                    $lng = $keys[0];
                }
                $stage++;
            } elsif ($stage == 2) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): removing part after \@ (if any)...");
                $lng =~ s/\@.*$//g;
                $stage++;
            } elsif ($stage == 3) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): removing encoding (if any)...");
                $lng =~ s/\..*$//g;
                $stage++;
            } elsif ($stage == 4) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): removing country part (if any)...");
                $lng =~ s/\_.*$//g;
                $stage++;
            } elsif ($stage == 5) {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): last chance, will take the first entry from a search in the list...");
                my @keys = grep /^$lng.*$/, keys %$locale_lang_map;
                foreach my $item (@keys) {
                    log_msg("$0:choose_language(): item: $item");
                }
                if (defined($keys[0])) {
                    $lng = $keys[0];
                    $stage++;
                } else {
                    log_msg("$0:choose_language(): nothing found...");
                    $stage = 0;
                }
            } else {
                log_msg("$0:choose_language(): $lng not defined!");
                log_msg("$0:choose_language(): can't do anything more...");
                $stage = 0;
            }
            log_msg("$0:choose_language(): lng = ".$lng);
        }
    }
}

1;