/*
 * ColorSelect.h
 *
 * Copyright (C) 1999 Jean-Hugues Deschenes.
 *
 * This is distributed under GPL.
 *
 * Header for Color selection window.
 *
 * History : 
 *    JH.D., 10/08/1999, Initial typing.
 *
 * Note : The current version of this toolkit is for linux 2.2.0.
 */

#ifndef __TRACE_TOOLKIT_COLOR_SELECT__
#define __TRACE_TOOLKIT_COLOR_SELECT__

#include "EventGraph.h"

#include <gdk/gdkprivate.h>
#include <gtk/gtk.h>

#define gCSLayoutHeight 5 /* Column count for the main packing table */
#define gCSLayoutWidth  3 /* Row count for the main packing table */

/* Define what the OK and Cancel callbacks look like */
typedef void _CSCBCancel
         (gpointer   /* The system view corresponding to this color selection */);
typedef void _CSCBOK
         (GtkWidget* /* The widget that generated the event */,
	  gpointer   /* The system view corresponding to this color selection */);

/* Color Selection window */
typedef struct _colorSelectWindow
{
  /* The data */
  gpointer      SysView;            /* The associated system view */
  GtkWidget*    ParentWin;          /* Parent window */
  _CSCBOK*      CBOK;   
  _CSCBCancel*  CBCancel;

  /* The widgets */
  GtkWidget*    Window;             /* Window to choose files */

  GtkWidget*    VBox;               /* Main Vbox */
  GtkWidget*    LineTypeVBox;       /* VBox to contain Line Type selection items */

  GtkWidget*    ListHBox;           /* HBox for list of configurable items & config controls */
  GtkWidget*    ButtonsHBox;        /* HBox for OK & Cancel buttons */

  GtkWidget*    MainTable;          /* Main packing table */

  GtkWidget*    ItemsList;          /* List of all configurable items */
  GtkWidget*    ScrolledList;       /* The scrollbars for the list */

  GtkWidget*    ColorLabel;         /* Label for the color selection button */
  GtkWidget*    ColorSelectButton;  /* Button to open the Color selection dialog */
  GtkWidget*    ColorDisplay;       /* Area, on the button, to display the current color */

  GtkWidget*    LineTypeFrame;      /* Frame for Line Type definition */
  GSList*       LTRadioBtnGroup;    /* Group for the radio buttons */
  GtkWidget*    LTRadioSolid;       /* Line Type Selection Radio Button - solid */
  GtkWidget*    LTRadioOnOffDash;   /* Line Type Selection Radio Button - on off dash */
  GtkWidget*    LTRadioDoubleDash;  /* Line Type Selection Radio Button - double dash */

  GtkWidget*    OKButton;           /* OK Button */
  GtkWidget*    CancelButton;       /* Cancel Button */

  GtkWidget*    ColorSelectDialog;  /* The GTK+ color selection dialog */

  /* The colors for each configurable item */
  GdkGC*        BackgroundGC;   /* The background color */
  GdkGC*        HorizonGC;      /* Mark the horizontal horizon for every process to ease view */
  GdkGC*        ProcessGC;      /* Time in process */
  GdkGC*        Process0GC;     /* Time in process 0 */
  GdkGC*        KernelGC;       /* Time in kernel  */
  GdkGC*        SelectedGC;     /* Line drawn across the selected event */
  GdkGC*        SysCallGC;      /* Transition due to syscall entry or exit */
  GdkGC*        TrapGC;         /* Transition due to trap entry or exit */
  GdkGC*        InterruptGC;    /* Transition due to interrupt */
  GdkGC*        TextGC;         /* Text color */

  /* The active GC */
  GdkGC*        ActiveGC;       /* This is the GC being configured i.e. selected */

} colorSelectWindow;

/* Function prototypes */
void               CSConnectSignals
                      (colorSelectWindow* /* The open trace window */);
colorSelectWindow* CSCreateColorSelectWindow
		      (gpointer           /* The System view */,
		       GtkWidget*         /* The parent window */,
                       _CSCBOK*           /* Function to call in case of OK */,
		       _CSCBCancel*       /* Function to call in case of cancel or close */);
void CSShowColorSelectWindow
                      (colorSelectWindow* /* The color selection window */,
		       eventGraph*        /* The event graph */);
void CSDestroyColorSelectWindow
                      (colorSelectWindow* /* The color selection window */);
void CSAddListItems
                      (GtkWidget*         /* The list to add to */,
		       char*              /* The text to display */,
		       GdkGC*             /* The GC to place in the callback */);



#endif /* __TRACE_TOOLKIT_COLOR_SELECT__ */

