/*
 * $Id: output.h,v 1.6 2000/06/27 13:07:24 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * $Id: output.h,v 1.6 2000/06/27 13:07:24 linus Exp $
 *
 *  output.h  --  initiate call to client.
 *
 *  Created by ceder 1990-07-17
 */

#ifndef _OUTPUT_H_ALREADY_INCLUDED__
#define _OUTPUT_H_ALREADY_INCLUDED__

extern  void
output_login (Pers_no		person,
	      const String	passwd,
	      Bool		visible);


extern  void
output_logout (void);


extern  void
output_change_conference (Conf_no	conference );



extern  void
output_change_name (Conf_no       conf_no,
		    const String  new_name);

extern  void
output_change_what_i_am_doing (const String  what_am_i_doing );



/******************************
*     Person-related calls    *
******************************/

/*
 *  Create a new person.  Returns 0 if any error occured.
 */
extern  void
output_create_person (const String  name,
		      const String  passwd );

extern  void
output_get_person_stat (Pers_no	     person);

extern  void
output_get_created_texts(Pers_no       pers_no,
			Local_text_no first,
			u_long        len );

extern  void
output_get_membership (Pers_no		  person,
		       u_short		  first,
		       u_short		  no_of_confs,
		       Bool		  want_read_texts );
		       
extern  void
output_set_priv_bits (Pers_no	 person,
		      Priv_bits  privileges );


extern  void
output_set_passwd (Pers_no	  person,
		   const String   old_pwd,
		   const String   new_pwd );

extern  void
output_query_read_texts (Pers_no	   pers_no,
		     Conf_no	   conf_no);



/****************************************
*	Conference-related calls	*
****************************************/


extern  void
output_create_conf (const String  name,
		    Conf_type	  type );


extern  void
output_delete_conf (Conf_no	conf );


extern  void
output_get_conf_stat (Conf_no		  conf_no);


extern  void
output_get_members (Conf_no	  conf,
		    u_short	  first,
		    u_short	  no_of_members);

extern  void
output_add_member (Conf_no	conf_no,
		   Pers_no	pers_no,
		   u_char	priority,
		   u_short	where	);


extern  void
output_sub_member (Conf_no	conf_no,
		   Pers_no	pers_no );


extern  void
output_set_unread (Conf_no   conf_no,
		   Text_no   no_of_unread);

extern  void
output_set_presentation (Conf_no   conf_no,
			 Text_no   text_no );

extern  void
output_set_etc_motd (Conf_no	  conf_no,
		     Text_no	  text_no );


extern  void
output_set_supervisor (Conf_no	  conf_no,
		       Conf_no	  admin	);

extern  void
output_set_permitted_submitters (Conf_no  conf_no,
				 Conf_no  perm_sub );

extern  void
output_set_super_conf (Conf_no	  conf_no,
		       Conf_no	  super_conf );

extern  void
output_set_conf_type (Conf_no	 conf_no,
		      Conf_type  type	);

extern  void
output_set_garb_nice (Conf_no	 conf_no,
		      Garb_nice  ndays	);



/********************************
*     Calls to handle marks     *
********************************/


extern  void
output_get_marks (void);



extern  void
output_mark_text (Text_no  text,
		  u_char   mark_type );




/*******************************
*     Calls to handle texts    *
*******************************/


extern  void
output_get_text (Text_no      text,
		 String_size  start_char,
		 String_size  end_char);


extern  void
output_get_text_stat (Text_no    text);

extern  void
output_mark_as_read (Conf_no		    conference,
		     int		    no_of_texts,
		     const Local_text_no  * text_arr   );


extern  void
output_create_text (const String       message,
		    u_short	       no_of_misc,
		    const Misc_info  * misc	     );

extern  void
output_create_anonymous_text (const String       message,
			      u_short	       no_of_misc,
			      const Misc_info  * misc	     );

extern void
output_delete_text( Text_no text_no );



extern  void
output_add_recipient (Text_no	  text_no,
		      Conf_no	  conf_no,
		      Info_type  type	);

extern  void
output_sub_recipient (Text_no	  text_no,
		      Conf_no	  conf_no );


extern  void
output_add_comment (Text_no	  comment,
		    Text_no 	  comment_to );


extern  void
output_sub_comment (Text_no	  comment,
		    Text_no	  comment_to );


extern  void
output_add_footnote (Text_no	  footnote,
		     Text_no 	  footnote_to );


extern  void
output_sub_footnote (Text_no	  footnote,
		     Text_no	  footnote_to );

extern  void
output_get_map (Conf_no	       conf_no,
		Local_text_no  first_local_no,
		Local_text_no  no_of_texts);

/*
 * Miscelaneous calls.
 */

extern  void
output_get_time ( void );

extern  void
output_get_info ( void );


extern void
output_set_motd_of_lyskom (Text_no motd);

extern void
output_enable (u_char ena_level);

extern void
output_sync (void);

extern void
output_shutdown (int exit_val);

extern void
output_send_message (Pers_no recipient,
		     const String message);

void
output_get_unread_confs (Pers_no pers_no);

void
output_get_last_text(struct tm	*clock_res);
 
void
output_get_next_text_no(Text_no start);

void
output_get_previous_text_no(Text_no start);

void
output_lookup_z_name(const String	name,
		     unsigned int	want_persons,
		     unsigned int	want_confs);

void
output_re_z_lookup(const String	name,
		   unsigned int	want_persons,
		   unsigned int	want_confs);

void
output_who_is_on_dynamic(unsigned int	want_visible,
			 unsigned int	want_invisible,
			 unsigned long	active_last);

#endif	/*  _OUTPUT_H_ALREADY_INCLUDED__  */
