/*
 *  client/function-main.c
 *		Some very important functions for executing
 *		commands.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */


#include <config.h>

#include <stdio.h>
/* #include <time.h> included from kom-types.h */
#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif


#include <kom-errno.h>
#include <kom-types.h>
#include <services.h>
#ifdef __vax__
#define __SIZE_T included from stdlib.h
#define __WCHAR_T included from stdlib.h
#endif

#include <libintl.h>

#include <zmalloc.h>
#include <s-string.h>
#include <s-collat.h>

#include "xoutput.h"
#include "read-line.h"
#include "commands.h"
#include "parser.h"
#include "edit.h"
#include "cache.h"
#include "quit.h"
#include "reading.h"

#include "internal.h"
#include "cmds.h"
#include "offline.h"


/* This is to emphasize that a function or variable is exported. */
#define Export


/*
 *  Global variables.  They are external, but should only be used
 *  within the files 'cmd-*.c'.
 */


/*  TRUE if the user wants to quit LysKOM  */
Export  Bool			  user_wants_to_quit;

/*  GOTO here when quitting */
Export jmp_buf			  toploop_jmpbuf;



/*
 *  External functions, to be exported.
 */


Export  void
command_loop (void)
{
    String		  comnd_string	= EMPTY_STRING;
    String		  arguments;
    Parse_info		  command;	/* Result from parsing */
    int			  i;		/* Index in small loops */

    Success (* next_command) (String argument);

    user_wants_to_quit = FALSE;

    setjmp (toploop_jmpbuf);

    newline();

    while (! user_wants_to_quit)
    {
        static int alread_uploaded = FALSE;

	newline();

	if (!offline)
	    handle_all_asyncs();	/* Read all asyncs. */

#define DEFAULT_COMMAND cmd_show_current_time
	next_command = DEFAULT_COMMAND; /* Default command. */

	if (!offline
	    && !alread_uploaded)
	{
	    Pers_no pers;

	    alread_uploaded = TRUE;
	    if (fetch_person_number(&pers)
		&& pers == cpn)
	    {
		next_command = cmd_upload;
	    }
	}

	set_prompt_if_in_review(&next_command);

	if (next_command == DEFAULT_COMMAND)
	{
	    /* The prompt was not set by review. */
	    if (reading_next_footnote_to_be_read() != 0)
	    {
		next_command = cmd_read_next_footnote;
	    }
	    else if (reading_next_comment_to_be_read() != 0)
	    {
		next_command = cmd_read_next_comment;
	    }
	    else if (reading_next_text_to_be_read() != 0)
	    {
		next_command = cmd_read_next_text;
	    }
	    else if (reading_next_conf_with_unread() != 0)
	    {
		next_command = cmd_goto_next_conf;
	    } 
	}

	{
	    String	last_prompt = command_name( next_command );

	    xprintf("%S - ", last_prompt );

	    theprompt = &last_prompt;
	    read_line (&comnd_string);	/* BUG! Retval not checked! */
	    theprompt = NULL;
	}
	printed_lines = 0;
	current_column = 0;
	newline();

	reading_confirm_read_texts();

	command = parse (comnd_string, cmd_list, TRUE, FALSE,
			 command_separators, DEFAULT_COLLAT_TAB);

	if (command.no_of_matches == 0)		/* If no matches found */
	{
	    xprintf(gettext("Kunde ej frsts av LysKOM\n"));
	}
	else if (command.no_of_matches == 1)	/* If only one match found */
	{
	    /* Default command? */
	    if (command.indexes[0] == -1)
	    {
		(next_command)(EMPTY_STRING);
	    }
	    else
	    {
		/* Print the full name of the command */
		s_xputs(cmd_list[command.indexes[0]].name);
		xputchar (' ');
		xflush (kom_outstream);
		/* Execute the command */
		arguments = EMPTY_STRING;
		s_strcpy (&arguments, command.arguments);
		function_list [ command.indexes [0] ] (arguments);
	    }
	}
	else		/* More than one match found */
	{
	    xprintf(gettext("Kommandot var tvetydigt. "
			    "Du kan mena ngot av dessa:\n"));
	    for ( i = 0 ;  i < command.no_of_matches ;  i++ )
	    {
		s_xputs (cmd_list[command.indexes[i]].name);
		newline();
	    }
	}
	
	/* Release memory allocated for index table */
	zfree (command.indexes);
    }
    s_clear (&comnd_string);
}   /* END: command_loop() */



/*
 *  The parameter 'ARGUMENT' in all the external functions, is a
 *  String containing the rest of the line, following the command.
 *  E g if the user gave the command "Skapa m|te Inl{gg }t mig",
 *  then the String "Inl{gg }t mig" is passed as the parameter
 *  'ARGUMENT' to the function responsible for the command 'skapa
 *  m|te'.  Leading and trailing spaces are skipped.  EMPTY_STRING
 *  is passed if no arguments to the command was given.
 */


/*  Log out from server and exit client.  */
Export  Success
cmd_quit_LysKOM (String   argument)
{
#define CLEAN_UP()	do { s_clear (&argument); } while (0)

    TOPLOOP_SETJMP();

    CHECK_NO_ARGUMENTS();

    if (!offline)
	kom_logout();
    else
    {
        /* Invalidate cache!
	 * This is because of the cache invalidation side effect of saving
	 * the membership.
	 */
        first_membership(0, NULL);
    }
    user_wants_to_quit = TRUE;
    xprintf (gettext("\nTack fr den hr gngen. "
		     "------------------------------ "
		     "P terseende.\n"));

    RETURN (OK);
#undef CLEAN_UP
}




Export  Success
cmd_not_yet_implemented (String   argument)
{
    xprintf(gettext("Denna finess r tyvrr inte implementerad n.\n"));
    s_clear (&argument);
    return  OK;
}
