/*
 *  client/internal-functions.h
 *		Header file for the functions only used by the
 *		functions in 'functions-*.c'.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 */


#ifndef  INTERNAL_H_ALREADY_INCLUDED__
#define  INTERNAL_H_ALREADY_INCLUDED__
#include <kom-types.h>

/*
 *  Global variables.  They are external, but should only be used
 *  within the files 'functions-*.c'.
 */

struct to_do_stack {
    enum { reading_comments_to_this_text }	doing;
    union {
	struct {
	    Text_no		  textnumber;
	} comments_to;
    } info;
    struct to_do_stack *    	next;
};
typedef struct to_do_stack * To_do_stack;

/*
 *
 */
typedef struct {
/*	enum { reading, writing } doing; */
        Text_no			  comment_to_read;
	Text_no			  last_viewed;
	Text_no			  last_normally_read;
	Local_text_no		  local_last_normally_read;
	Text_no			  global_to_mark_as_read;
	To_do_stack		  thingstodo;
/*	int			  default_next_command; */
/*	Bool			  auto_enter_next_command; */
}  Internal_state_t;


/* And here's where it is really stored.... */
extern  Internal_state_t	  reading_state;


struct read_texts {
	Text_no		  text;
	Text_no		  parent;
};

struct read_text_list {
	long			  allocated_size;
	long			  no_of_texts;
	struct read_texts	* text_list;
};

#define READ_TEXT_HASH		  256
extern  struct read_text_list	  read_texts[READ_TEXT_HASH];



/*  TRUE if the user wants to quit LysKOM  */
extern  Bool		  user_wants_to_quit;




/*  ==================================================================  */
/*	  Internal functions and macros, NOT to be used outside		*/
/*	  'functions*.c'						*/


#define newline()		xputchar ('\n')
#if 0
#define MAX(n1, n2)		(((n1) > (n2)) ? (n1) : (n2))
#define MIN(n1, n2)		(((n1) < (n2)) ? (n1) : (n2))
#endif


/*
 *  Macro to check that no arguments are given.  Useful in many
 *  commands.  Does a 'return FAILURE' if arguments were given.
 */
#define	CHECK_NO_ARGUMENTS()	do {					\
    if (! s_empty (argument))	/* No arguments are allowed  */		\
    {									\
	xprintf(gettext("Oknt argument: "));				\
	s_puts (argument);						\
	newline();							\
	RETURN (FAILURE);						\
    }							} while (0)



/*
 *  Ask user to answer Yes, No or Maybe.  Returns TRUE or FALSE.
 *  Any illegal anser is taken as No.
 */
extern  Bool
yes_or_no_p (void);

/*
 *  Check if user has typed on the keyboard.
 */
extern Bool user_has_typed_during(int);
extern Bool user_has_typed(void);


/*
 *  Find all conferences matching the name NAME.  Also supports the
 *  notation "conference nnn" and "person nnn", where nnn is a number.
 *  If one of the latter notations are used, the 'pers_or_conf' field
 *  of the result will reflect the notation used, if it *is* a person.
 *  If the notation 'person nnn' is used and it *isn't* a person, then
 *  it won't match, i e the EMPTY_CONF_Z_INFO_LIST will be returned.
 */
extern  Conf_z_info_list
find_conf_or_pers_no (const String	name);



/*
 *  Ask the user for the name or number of one conference or person.
 */
extern  Conf_z_info
ask_for_conf (String			* name,
	      const unsigned char	* prompt);



/*
 *  Find all conferences matching the name NAME.  Also supports the
 *  notation "person nnn", where nnn is a number.
 */
extern  Conf_z_info_list
find_person_number (const String	name);


/*
 *  Perform the actions to join a conference.  Inform the
 *  user if he is not allowed to join it.
 */
extern  Success
do_join_conf (Conf_no	conf_to_join);



/*
 *  Find the position of the next conference with unread news
 *  in.  Start looking at START_POSITION in the list of
 *  conferences the person is member of.  Uses the global
 *  variable 'this_person_stat' (i e does not fetch the status
 *  from the server).
 */
extern  Conf_no
find_next_conf_with_unread (Conf_no	start_position);



/*
 *  Print the name of the conference with the number CONF.
 *  Doesn't print anything if it can't find the name.
 */
extern  void
print_conf_name (Conf_no	conf);

/*
 *  Print a type for the conference CONF 
 */
extern  void
print_conf_type (Conference	* conf);



/*
 *  Show the status of a person.  The conference status and
 *  member-list of the person's letterbox, should already have been
 *  fetched, and be pointed to by CONF and MEMBERS respectively.  They
 *  should be released by the caller.
 */
extern  Success
show_pers_status (Conf_z_info		  conf_to_stat,
		  Conference		* conf,
		  Person		* pers		);



/*
 *  Show some short information about a conference - name, number,
 *  creator, creation time and supervisor.
 */
extern  Success
show_short_conf_status (Conf_z_info	  conf_to_stat,
			Conference	* conf		);



/*
 *  Show some more information about a conference - number of texts,
 *  number of members, type of conf, super conf, comment conf,
 *  permitted submitters.
 */
extern  Success
show_more_conf_status (Conf_z_info	  conf_to_stat,
		       Conference	* conf		);



/*
 *  Show a list of members in a conference.  The conferences status
 *  and its member-list, should already have been fetched, and be
 *  pointed to by CONF and MEMBERS respectively.  They should be
 *  released by the caller.
 */
extern  Success
show_member_list (Conf_z_info	  conf_to_stat,
		  Conference	* conf,
		  Member_list	* member);



/*
 *  Fetch and show the text WANTED if the server is willing to let
 *  the person see it.
 */
extern  Success
show_text_no (Text_no	wanted);



/*
 *  Print the header line for a text, containing the text number,
 *  the date and time of its creation, the number of lines, and
 *  the author.
 */
extern  void
print_text_header (Text_no		  number,
		   const Text_stat	* stat   );



#define	PRINT_RECPT		 000001
#define PRINT_CC_RECPT		 000002
#define PRINT_COMM_TO		 000004
#define PRINT_FOOTN_TO		 000010
#define PRINT_COMM_IN		 000020
#define PRINT_FOOTN_IN		 000040
#define PRINT_ALL_MISC		0177777

/*
 *  Print the misc-items in the list pointed to by MISC_LIST with
 *  the length NO_OF_MISC, printing only those misc-items matching
 *  WHAT_TO_PRINT, a bitwise or of the above #define's.
 */
extern  void
print_misc_list (const Misc_info	* misc_list,
		 unsigned short		  no_of_misc,
		 unsigned short		  what_to_print);



/*
 *  Print the subject line of a text.
 */
extern  void
print_subject_line (const unsigned char	* subject_text,
		    const String	text		);



/*
 *  Print all of the text, except for the subject line.
 */
extern  void
print_rest_of_text (const String	text);



/*
 *  Print the time TIME
 */
extern  void
print_time (const struct tm	* time_res);



/*
 *  Continue the writing of a text that was started earlier.
 */
extern  Success
do_continue_writing (int  edit_no);



/*
 *  Find the next unread text in the current conference and
 *  put the result in NEXT_TO_READ.  Gives the result 0 if
 *  there are no more unread.
 *  Returns OK if everything went fine, and FAILURE if something
 *  (non-fatal) went wrong, e g couldn't get the status of the
 *  current conference.  The global variable KOM_ERRNO is set
 *  to the error.
 */
/* BUG: does not check if a text already has been read,
   via a "]terse"-command, or in another conference	*/
extern  Success
find_next_unread_text (Local_text_no	* next_to_read);

extern  Bool
has_been_read (Text_no);

Text_no
find_comment_to_read(Text_no skip);


/*
 *  Report the number of unread texts the person WHO has in
 *  conference WHERE.
 */
extern  long
unread_in_conf (Pers_no	    who,
		Conf_no	    where);


/* Returns the value of more_confs i.e the number of unread confs left.
 */
extern int
unread_confs_left(void);


/* Returns the amount of texts left in this conf to be read.
 * If we havnt read the amount of unread then get them.
 * Returns 0 if not in any conf or there are 0 unread left.
 */
extern int
unread_texts_left(void);


/* Decreases the amount of unread texts.
 * This is to get a quicker count.
 */
extern int
decrease_unread_texts_left(void);


/* Return True if MEMBERSHIP is a member of CONF_NO_LIST
 * else return False
 */
extern Bool
membership_in_conf_no_list (Membership membership,
			    Conf_no_list list);



/* Maintaining reading structure. */
extern void
push_read_comments_to(Text_no);

extern void
pop_to_do(void);

extern To_do_stack
peek_to_do(void);



/* These are from cmd-review.c. The communication interface. */
void
set_prompt_if_in_review(Success (**next_comand) (String argument));

void
review_reset(void);

/* Character set convertions */
extern int
iso_to_pc8(int);

extern int
pc8_to_iso(int);

extern int
iso_to_pc7(int);

extern int
pc7_to_iso(int);

extern int
iso_to_mac(int);

extern int
mac_to_iso(int);

#endif	/*  INTERNAL_H_ALREADY_INCLUDED__  */
