/*
 *  misc-parser.c
 *		Parse a list of misc-items for LysKOM texts.
 *
 *
 *  Copyright (C) 1990,2001	Lysator Computer Club,
 *				Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#include <config.h>
#include "misc-parser.h"

#define Export


/*
 *  Return TRUE if the next misc-item exist, and it is of type
 *  MTYPE, FALSE otherwise.  Can only be used within the function
 *  parse_next_misc().
 */
#define NEXT_IS(mtype)						\
    (*info < stop_pointer && (*info)->type == (mtype))


#define BARF	{  result.type = m_error;  return  result;  }

/*
 * The old (1990) implementation returned a struct were there were different
 * fields for the Conf_no reference of the two kinds of recipients and
 * different fields for the four kinds of Text_no references.
 * Since at every single place in the code where this function was used
 * (9 places) we had to do a lot of special work to handle this, this was
 * changed 2001.
 * The new implementation returns the Conf_no in the same field recipient
 * both if it is a m_recpt and a m_cc_recpt. Which one it is is present in the
 * type field as always.
 * The new implementation also returns the Text_no in the same field text_ref.
 * Which kind it is is present in the type field.
 */

/*
 *  Parse out a "group" of misc-items from a list of them pointed
 *  to by *INFO.  *STOP_POINTER must point to the item directly
 *  after the last in the list.  **INFO will be incremented to
 *  point to the item after the recently parsed out group.  The
 *  return value will have the TYPE field set to 'm_end_of_list'
 *  when the end of the list has been reached.
 */
Export  Misc_info_group
parse_next_misc (const Misc_info	** info,
		 const Misc_info	 * stop_pointer)

{
    Misc_info_group	  result;

    
	
    /* Clear the 'result' struct */
    result.type = m_error;
    result.recipient = 0;
    result.local_no = 0;
    result.is_received = FALSE;
    result.text_ref = 0;
    result.sender = 0;
    result.is_sent = FALSE;


    if (*info >= stop_pointer)
    {
	result.type = m_end_of_list;
	return  result;
    }

    
    /* Now, do the real work... */
    switch ((*info)->type)
    {
    case  recpt:	/* These two are so similar that they can */
    case  cc_recpt:	/* Be handled in the same clause	  */
	if ((*info)->type == recpt)
	{
	    result.type = m_recpt;
	}
	else
	{
	    result.type = m_cc_recpt;
	}
	result.recipient = (*(*info)++).datum.recipient;
	
	/* There should follow a 'Local no', but check nevertheless */
	/* Well, if we are writing a text then there is no local-no */
	if (! NEXT_IS (loc_no))
	    result.local_no = 0;
	else
	    result.local_no = (*(*info)++).datum.local_no;

	if (NEXT_IS (rec_time))
	{
	    result.is_received = TRUE;
	    result.received_at = (*(*info)++).datum.received_at;
	}

	if (NEXT_IS (sent_by))
	{
	    result.sender = (*(*info)++).datum.sender;
	    /* There _should_ be a 'sent_at' here... */
	    if (! NEXT_IS (sent_at))
		{ BARF }
	    /* Let the following if clause insert the 'sent_at' data. */
	}
	if (NEXT_IS (sent_at))
	{
	    result.is_sent = TRUE;
	    result.sent_at = (*(*info)++).datum.sent_at;
	}

	break;


    case  comm_to:
	result.type = m_comm_to;
	result.text_ref = (*(*info)++).datum.comment_to;

	if (NEXT_IS (sent_by))
	{
	    result.sender = (*(*info)++).datum.sender;
	    /* There _should_ be a 'sent_at' here. */
	    if (! NEXT_IS (sent_at))
		{ BARF }
	    /* Let the following if clause insert the 'sent_at' data. */
	}
	if (NEXT_IS (sent_at))
	{
	    result.is_sent = TRUE;
	    result.sent_at = (*(*info)++).datum.sent_at;
	}

	break;


    case  footn_to:
	result.type = m_footn_to;
	result.text_ref = (*(*info)++).datum.footnote_to;

	if (NEXT_IS (sent_at))
	{
	    result.is_sent = TRUE;
	    result.sent_at = (*(*info)++).datum.sent_at;
	}

	break;


    case  comm_in:
	result.type = m_comm_in;
	result.text_ref = (*(*info)++).datum.commented_in;
	break;


    case  footn_in:
	result.type = m_footn_in;
	result.text_ref = (*(*info)++).datum.footnoted_in;
	break;


#ifndef COMPILE_CHECKS
    default:
	result.type = m_error;
	break;
#endif
    }

    return  result;
}
