/*
 * $Id: misc.h,v 1.8 2000/08/24 00:34:18 cbond Exp $
 */

#if !defined(__include_misc_h__)
#define __include_misc_h__

#include <sys/types.h>

/* Miscellaneous macros for speed, cleanliness, and general laziness.
 */
#undef	MALLOC
#undef	FREE
#define MALLOC(t, s)	(t *) malloc(sizeof(t) * s)
#define FREE(p)		free(p)

/* arr_scr is the main screen we're drawing to. */
extern arr_scr_t *arr_scr;

/* These declarations are:
 * 	- a list of colors that should be converted to bold on old terminals;
 * 	- a similar list of colors that are to be converted to inverse;
 * 	- bad characters that cannot be printed to the screen, etc.
 */
extern u_char bold_color[], inverse_color[], arr_ext_conv[], arr_norm_conv[];

#endif
