#ifndef _BONOBOMM_SERVERS_SERVANT_OWNER_H
#define _BONOBOMM_SERVERS_SERVANT_OWNER_H

/* $Id: servantowner.h,v 1.1 2003/11/17 22:15:29 bowens Exp $ */


/* servantowner.h
 *
 * Copyright (C) 2003 The libbonobomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <bonobo/bonobo-main.h>
#include <orbitcpp/orb-cpp/orbitcpp.h>



namespace Gnome
{

namespace Bonobo
{

namespace Servers
{

// Encapsulate ownership of a single servant and automatically
// deactivate in bonobo POA at end of lifetime.
template <class S>
class ServantOwner {
protected:
	S m_servant;

	~ServantOwner()
	{
		_orbitcpp::CEnvironment env;
		PortableServer_POA poa = bonobo_poa();
								     

		PortableServer_Servant servant =
		m_servant._orbitcpp_get_c_servant();
		PortableServer_ObjectId* oid =
		PortableServer_POA_servant_to_id(poa, servant, env._orbitcpp_cobj());
		env.propagate_poaex();
		PortableServer_POA_deactivate_object(poa, oid,
		env._orbitcpp_cobj());
		env.propagate_poaex();
	}
};

} //namespace Servers
} //namespace Bonobo
} //namespace Gnome

	
#endif //_BONOBOMM_SERVERS_UNKNOWN_CPPIMPL_H

