require 'test/unit'
require 'gettext/parser/ruby'
require 'gettext/parser/glade'

class TestGetTextParser < Test::Unit::TestCase
  def test_ruby
    ary = GetText::RubyParser.parse(['test_rubyparser.rb'])

    assert_equal(['aaa', 'test_rubyparser.rb:8'], ary[0])
    assert_equal(['aaa\n', 'test_rubyparser.rb:12'], ary[1])
    assert_equal(['bbb\nccc', 'test_rubyparser.rb:16'], ary[2])
    assert_equal(['bbb\nccc\nddd\n', 'test_rubyparser.rb:20'], ary[3])
    assert_equal(['eee', 'test_rubyparser.rb:27', 'test_rubyparser.rb:31'], ary[4])
    assert_equal(['fff', 'test_rubyparser.rb:31'], ary[5])
    assert_equal(['ggghhhiii', 'test_rubyparser.rb:35'], ary[6])
    assert_equal(['a"b"c"', 'test_rubyparser.rb:41'], ary[7])
#    assert_equal(['d"e"f"', 'test_rubyparser.rb:45'], ary[8])
    assert_equal(['jjj', 'test_rubyparser.rb:49'], ary[9])
    assert_equal(['kkk', 'test_rubyparser.rb:50'], ary[10])
    assert_equal(['lllmmm', 'test_rubyparser.rb:54'], ary[11])
    assert_equal(['nnn\nooo', 'test_rubyparser.rb:62'], ary[12])
  end

  def test_ruby_N
    ary = GetText::RubyParser.parse(['test_rubyparser_N.rb'])

    assert_equal(['aaa', 'test_rubyparser_N.rb:8'], ary[0])
    assert_equal(['aaa\n', 'test_rubyparser_N.rb:12'], ary[1])
    assert_equal(['bbb\nccc', 'test_rubyparser_N.rb:16'], ary[2])
    assert_equal(['bbb\nccc\nddd\n', 'test_rubyparser_N.rb:20'], ary[3])
    assert_equal(['eee', 'test_rubyparser_N.rb:27', 'test_rubyparser_N.rb:31'], ary[4])
    assert_equal(['fff', 'test_rubyparser_N.rb:31'], ary[5])
    assert_equal(['ggghhhiii', 'test_rubyparser_N.rb:35'], ary[6])
    assert_equal(['a"b"c"', 'test_rubyparser_N.rb:41'], ary[7])
#    assert_equal(['d"e"f"', 'test_rubyparser_N.rb:45'], ary[8])
    assert_equal(['jjj', 'test_rubyparser_N.rb:49'], ary[9])
    assert_equal(['kkk', 'test_rubyparser_N.rb:50'], ary[10])
    assert_equal(['lllmmm', 'test_rubyparser_N.rb:54'], ary[11])
    assert_equal(['nnn\nooo', 'test_rubyparser_N.rb:62'], ary[12])
  end

  def test_ruby_n
    ary = GetText::RubyParser.parse(['test_rubyparser_n.rb'])
    assert_equal(["aaa\000aaa2", 'test_rubyparser_n.rb:8'], ary[0])
    assert_equal(["bbb\\n\000ccc2\\nccc2", 'test_rubyparser_n.rb:12'], ary[1])
    assert_equal(["ddd\\nddd\000ddd2\\nddd2", 'test_rubyparser_n.rb:16'], ary[2])
    assert_equal(["eee\\neee\\n\000eee2\\neee2\\n", 'test_rubyparser_n.rb:21'], ary[3])
    assert_equal(["ddd\\neee\\n\000ddd\\neee2", 'test_rubyparser_n.rb:27'], ary[4])
    assert_equal(["fff\000fff2", 'test_rubyparser_n.rb:34', 'test_rubyparser_n.rb:38'], ary[5])
    assert_equal(["ggg\000ggg2", 'test_rubyparser_n.rb:38'], ary[6])
    assert_equal(["ggghhhiii\000jjjkkklll", 'test_rubyparser_n.rb:42'], ary[7])
#    assert_equal(["a"b"c"\000a"b"c"2", 'test_rubyparser_n.rb:51'], ary[8])
    assert_equal(["mmmmmm\000mmm2mmm2", 'test_rubyparser_n.rb:59'], ary[10])
    assert_equal(["nnn\000nnn2", 'test_rubyparser_n.rb:60'], ary[11])
  end

  def test_glade
    ary = GetText::GladeParser.parse(['test_gladeparser.glade'])

    assert_equal(['window1', 'test_gladeparser.glade:8'], ary[0])
    assert_equal(['normal text', 'test_gladeparser.glade:29'], ary[1])
    assert_equal(['1st line\n2nd line\n3rd line', 'test_gladeparser.glade:50'], ary[2])
    assert_equal(['<span color="red" weight="bold" size="large">markup </span>', 'test_gladeparser.glade:73'], ary[3])
    assert_equal(['<span color="red">1st line markup </span>\n<span color="blue">2nd line markup</span>', 'test_gladeparser.glade:94'], ary[4])
    assert_equal(['<span>&quot;markup&quot; with &lt;escaped strings&gt;</span>', 'test_gladeparser.glade:116'], ary[5])
    assert_equal(['duplicated', 'test_gladeparser.glade:137', 'test_gladeparser.glade:158'], ary[6])
  end
end
