/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  drawable_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_HYPERLINK_CLASS_H
#define INTI_ATK_HYPERLINK_CLASS_H

#include <inti/glib/private/object_p.h>

namespace Inti {

namespace Atk {

class HyperlinkClass
{
public:
	static void init(AtkHyperlinkClass *g_class);

	static GType get_type();

	static void* create();

	static gchar* get_uri_proxy(AtkHyperlink *link, gint i);

	static AtkObject* get_object_proxy(AtkHyperlink *link, gint i);

	static gint get_end_index_proxy(AtkHyperlink *link);

	static gint get_start_index_proxy(AtkHyperlink *link);

	static gboolean is_valid_proxy(AtkHyperlink *link);

	static gint get_n_anchors_proxy(AtkHyperlink *link);

	static guint link_state_proxy(AtkHyperlink *link);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_HYPERLINK_CLASS_H
