/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  viewport.cc - GtkViewport C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "viewport.h"
#include "private/viewport_p.h"

using namespace Inti;

Gtk::Viewport::Viewport(GtkViewport *viewport, bool reference)
: Bin((GtkBin*)viewport, reference)
{
}

Gtk::Viewport::Viewport() 
: Bin((GtkBin*)ViewportClass::create())
{
}

Gtk::Viewport::Viewport(Adjustment *hadjustment, Adjustment *vadjustment)
: Bin((GtkBin*)ViewportClass::create())
{
	if (hadjustment)
		set_hadjustment(hadjustment);
	if (vadjustment)
		set_vadjustment(vadjustment);
}

Gtk::Viewport::~Viewport()
{
}

GtkViewportClass*
Gtk::Viewport::gtk_viewport_class() const 
{ 
	return get_class<GtkViewportClass>(); 
}
	
Gtk::Viewport::operator GtkViewport* () const 
{ 
	return this ? gtk_viewport() : 0;  
}

Gtk::Adjustment*
Gtk::Viewport::get_hadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_viewport_get_hadjustment(gtk_viewport()));
}

Gtk::Adjustment*
Gtk::Viewport::get_vadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_viewport_get_vadjustment(gtk_viewport()));
}

Gtk::ShadowType
Gtk::Viewport::get_shadow_type() const
{
	return (ShadowType)gtk_viewport_get_shadow_type(gtk_viewport());
}

void 
Gtk::Viewport::set_hadjustment(Adjustment *adjustment)
{
	gtk_viewport_set_hadjustment(gtk_viewport(), *adjustment);
}
	
void 
Gtk::Viewport::set_vadjustment(Adjustment *adjustment)
{
	gtk_viewport_set_vadjustment(gtk_viewport(), *adjustment);
}

void
Gtk::Viewport::set_shadow_type(ShadowType type)
{
	gtk_viewport_set_shadow_type(gtk_viewport(), (GtkShadowType)type);
}

/*  Gtk::ViewportClass
 */

void
Gtk::ViewportClass::init(GtkViewportClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
	g_class->set_scroll_adjustments = &set_scroll_adjustments_proxy;
}

GType
Gtk::ViewportClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VIEWPORT, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ViewportClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ViewportClass::set_scroll_adjustments_proxy(GtkViewport *viewport, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	Viewport *tmp_viewport = G::Object::pointer<Viewport>(viewport);
	if (tmp_viewport)
		tmp_viewport->on_set_scroll_adjustments(G::Object::wrap<Gtk::Adjustment>(hadjustment),
		                                        G::Object::wrap<Gtk::Adjustment>(vadjustment));
	else
	{
		GtkViewportClass *g_class = G::TypeInstance::class_peek_parent<GtkViewportClass>(GTK_VIEWPORT_GET_CLASS(viewport));
		if (g_class->set_scroll_adjustments)
			g_class->set_scroll_adjustments(viewport, hadjustment, vadjustment);
	}
}

/*  Signal handlers
 */

void
Gtk::Viewport::on_set_scroll_adjustments(Adjustment *hadjustment, Adjustment *vadjustment)
{
	GtkViewportClass *g_class = class_peek_parent<GtkViewportClass>(gtk_viewport_class());
	if (g_class->set_scroll_adjustments)
		g_class->set_scroll_adjustments(gtk_viewport(), *hadjustment, *vadjustment);
}

/*  Properties
 */

const Gtk::Viewport::HAdjustmentPropertyType Gtk::Viewport::hadjustment_property("hadjustment");

const Gtk::Viewport::VAdjustmentPropertyType Gtk::Viewport::vadjustment_property("vadjustment");

const Gtk::Viewport::ShadowTypePropertyType Gtk::Viewport::shadow_type_property("shadow_type");

/*  Signals
 */

const Gtk::Viewport::SetScrollAdjustmentsSignalType Gtk::Viewport::set_scroll_adjustments_signal("set_scroll_adjustments");
