/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  break.cc - PangoLogAttr C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define PANGO_ENABLE_ENGINE
 
#include "break.h"
#include "item.h"
#include <string.h>

using namespace Inti;

Pango::LogAttr::LogAttr()
{
	memset(this, 0, sizeof(*this));
}

Pango::LogAttr::operator PangoLogAttr* () const
{
	return this ? pango_log_attr() : 0;
}

bool
Pango::LogAttr::is_line_break() const
{
	return pango_log_attr()->is_line_break != 0;
}

bool
Pango::LogAttr::is_mandatory_break() const
{
	return pango_log_attr()->is_mandatory_break != 0;
}

bool
Pango::LogAttr::is_char_break() const
{
	return pango_log_attr()->is_char_break != 0;
}

bool
Pango::LogAttr::is_white() const
{
	return pango_log_attr()->is_white != 0;
}

bool
Pango::LogAttr::is_cursor_position() const
{
	return pango_log_attr()->is_cursor_position != 0;
}

bool
Pango::LogAttr::is_word_start() const
{
	return pango_log_attr()->is_word_start != 0;
}

bool
Pango::LogAttr::is_word_end() const
{
	return pango_log_attr()->is_word_end != 0;
}

bool
Pango::LogAttr::is_sentence_boundary() const
{
	return pango_log_attr()->is_sentence_boundary != 0;
}

bool
Pango::LogAttr::is_sentence_start() const
{
	return pango_log_attr()->is_sentence_start != 0;
}

bool
Pango::LogAttr::is_sentence_end() const
{
	return pango_log_attr()->is_sentence_end != 0;
}

void
Pango::LogAttr::set_is_line_break(bool setting)
{
	pango_log_attr()->is_line_break = setting;
}

void
Pango::LogAttr::set_is_mandatory_break(bool setting)
{
	pango_log_attr()->is_mandatory_break = setting;
}

void
Pango::LogAttr::set_is_char_break(bool setting)
{
	pango_log_attr()->is_char_break = setting;
}

void
Pango::LogAttr::set_is_white(bool setting)
{
	pango_log_attr()->is_white = setting;
}

void
Pango::LogAttr::set_is_cursor_position(bool setting)
{
	pango_log_attr()->is_cursor_position = setting;
}

void
Pango::LogAttr::set_is_word_start(bool setting)
{
	pango_log_attr()->is_word_start = setting;
}

void
Pango::LogAttr::set_is_word_end(bool setting)
{
	pango_log_attr()->is_word_end = setting;
}

void
Pango::LogAttr::set_is_sentence_boundary(bool setting)
{
	pango_log_attr()->is_sentence_boundary = setting;
}

void
Pango::LogAttr::set_is_sentence_start(bool setting)
{
	pango_log_attr()->is_sentence_start = setting;
}

void
Pango::LogAttr::set_is_sentence_end(bool setting)
{
	pango_log_attr()->is_sentence_end = setting;
}

void
Pango::break_text(const String& text, const Analysis& analysis, std::vector<LogAttr>& attrs)
{
	g_return_if_fail(!attrs.empty());
	PangoLogAttr *tmp_attrs = reinterpret_cast<PangoLogAttr*>(&attrs[0]);
	pango_break(text.c_str(), text.size(), analysis.pango_analysis(), tmp_attrs, attrs.size());
}

void
Pango::find_paragraph_boundary(const String& text, int *paragraph_delimiter_index, int *next_paragraph_start)
{
	pango_find_paragraph_boundary(text.c_str(), text.size(), paragraph_delimiter_index, next_paragraph_start);
}

void
Pango::get_log_attrs(const String& text, PangoLanguage *language, std::vector<LogAttr>& attrs, int level)
{
	g_return_if_fail(!attrs.empty());
	PangoLogAttr *tmp_attrs = reinterpret_cast<PangoLogAttr*>(&attrs[0]);
	pango_get_log_attrs(text.c_str(), text.size(), level, language, tmp_attrs, attrs.size());
}


