/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management;

import mx4j.util.Utils;
import mx4j.server.MBeanIntrospector;

/**
 * Metadata class for MBean notifications.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.8 $
 */
public class MBeanNotificationInfo extends MBeanFeatureInfo
{
   private static final long serialVersionUID = -3888371564530107064L;

   /**
    * @serial The notification types
    */
   private String[] types;

   /**
    * Creates a new MBeanNotificationInfo
    * @param notifsType The types
    * @param name The classname of the Notifications emitted
    * @param description The description for these notifications
    */
   public MBeanNotificationInfo(String[] notifsType, String name, String description)
   {
      super(name, description);
      this.types = notifsType == null ? new String[0] : notifsType;
   }

   /**
    * Returns the types of the notifications emitted.
    */
   public String[] getNotifTypes()
   {
      return types;
   }

   public int hashCode()
   {
      return super.hashCode() ^ Utils.arrayHashCode(getNotifTypes());
   }

   public boolean equals(Object obj)
   {
      if (!super.equals(obj)) return false;

      try
      {
         MBeanNotificationInfo other = (MBeanNotificationInfo)obj;
         return Utils.arrayEquals(getNotifTypes(), other.getNotifTypes());
      }
      catch (ClassCastException ignored)
      {
      }
      return false;
   }
}
