/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package test.mx4j.tools.remote.soap;

import java.util.Map;
import java.util.HashMap;
import java.net.MalformedURLException;
import java.io.IOException;

import javax.management.remote.JMXServiceURL;

import test.javax.management.remote.JMXConnectorTestCase;
import org.apache.axis.AxisFault;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.10 $
 */
public class SOAPConnectorTest extends JMXConnectorTestCase
{
   public SOAPConnectorTest(String s)
   {
      super(s);
   }

   public JMXServiceURL createJMXConnectorServerAddress() throws MalformedURLException
   {
      return new JMXServiceURL("soap", "localhost", 8080, "/axis/services/jmxconnector");
   }

   public Map getEnvironment()
   {
      return new HashMap();
   }

   /**
    * The SOAPConnector does not handle gracefully the case of a SecurityException thrown by a
    * JMXAuthenticator. This is more an Axis problem, but for now we fix the test.
    */
   protected void testJMXAuthenticatorConnect(JMXServiceURL url, Map environment) throws SecurityException, IOException
   {
      try
      {
         super.testJMXAuthenticatorConnect(url, environment);
      }
      catch (AxisFault x)
      {
         String name = x.getFaultString();
         if (name.startsWith(SecurityException.class.getName())) throw new SecurityException();
         throw x;
      }
   }

   /**
    * No default classloader for the SOAPConnector (at least not now).
    * It may be added later, but for now we fix the test.
    */
   public void testDefaultClassLoader() throws Exception
   {
      // Do nothing
   }

   public void testConnectWithProviderClassLoader() throws Exception
   {
      // Do nothing since messing with the context classloader causes the SOAPConnectorServer to fail its start
   }
}
